/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.identityhub.api.configuration;

import com.fasterxml.jackson.databind.DeserializationFeature;
import jakarta.ws.rs.core.SecurityContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.edc.identityhub.spi.authorization.AuthorizationService;
import org.eclipse.edc.identityhub.spi.participantcontext.model.ParticipantResource;
import org.eclipse.edc.runtime.metamodel.annotation.Configuration;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provider;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.runtime.metamodel.annotation.Settings;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.result.ServiceResult;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.system.apiversion.ApiVersionService;
import org.eclipse.edc.spi.system.apiversion.VersionRecord;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.web.spi.configuration.PortMapping;
import org.eclipse.edc.web.spi.configuration.PortMappingRegistry;

@Extension(value="Identity API Extension")
public class IdentityApiConfigurationExtension
implements ServiceExtension {
    public static final String NAME = "Identity API Extension";
    private static final String API_VERSION_JSON_FILE = "identity-api-version.json";
    @Configuration
    private IdentityApiConfiguration apiConfiguration;
    @Inject
    private TypeManager typeManager;
    @Inject
    private PortMappingRegistry portMappingRegistry;
    @Inject
    private ApiVersionService apiVersionService;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        this.portMappingRegistry.register(new PortMapping("identity", this.apiConfiguration.port(), this.apiConfiguration.path()));
        this.registerVersionInfo(this.getClass().getClassLoader());
    }

    @Provider(isDefault=true)
    public AuthorizationService authorizationService() {
        return new AllowAllAuthorizationService();
    }

    private void registerVersionInfo(ClassLoader resourceClassLoader) {
        try (InputStream versionContent = resourceClassLoader.getResourceAsStream(API_VERSION_JSON_FILE);){
            if (versionContent == null) {
                throw new EdcException("Version file not found or not readable.");
            }
            Stream.of((VersionRecord[])this.typeManager.getMapper().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).readValue(versionContent, VersionRecord[].class)).forEach(vr -> this.apiVersionService.addRecord("identity", vr));
        }
        catch (IOException e) {
            throw new EdcException((Throwable)e);
        }
    }

    @Settings
    record IdentityApiConfiguration(@Setting(key="web.http.identity.port", description="Port for identity api context", defaultValue="15151") int port, @Setting(key="web.http.identity.path", description="Path for identity api context", defaultValue="/api/identity") String path) {
    }

    private static class AllowAllAuthorizationService
    implements AuthorizationService {
        private AllowAllAuthorizationService() {
        }

        public ServiceResult<Void> isAuthorized(SecurityContext securityContext, String resourceId, Class<? extends ParticipantResource> resourceClass) {
            return ServiceResult.success();
        }

        public void addLookupFunction(Class<?> resourceClass, Function<String, ParticipantResource> checkFunction) {
        }
    }
}

