/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.service.spi.result;

import java.util.List;
import org.eclipse.edc.service.spi.result.ServiceFailure;
import org.eclipse.edc.spi.command.CommandFailure;
import org.eclipse.edc.spi.command.CommandResult;
import org.eclipse.edc.spi.result.AbstractResult;
import org.eclipse.edc.spi.result.Failure;
import org.eclipse.edc.spi.result.StoreFailure;
import org.eclipse.edc.spi.result.StoreResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServiceResult<T>
extends AbstractResult<T, ServiceFailure, ServiceResult<T>> {
    protected ServiceResult(T content, ServiceFailure failure) {
        super(content, (Failure)failure);
    }

    public static <T> ServiceResult<T> success(T content) {
        return new ServiceResult<T>(content, null);
    }

    public static <T> ServiceResult<T> conflict(String message) {
        return new ServiceResult<Object>(null, new ServiceFailure(List.of(message), ServiceFailure.Reason.CONFLICT));
    }

    public static <T> ServiceResult<T> notFound(String message) {
        return new ServiceResult<Object>(null, new ServiceFailure(List.of(message), ServiceFailure.Reason.NOT_FOUND));
    }

    public static <T> ServiceResult<T> badRequest(String ... message) {
        return ServiceResult.badRequest(List.of(message));
    }

    public static <T> ServiceResult<T> badRequest(List<String> messages) {
        return new ServiceResult<Object>(null, new ServiceFailure(messages, ServiceFailure.Reason.BAD_REQUEST));
    }

    public static <T> ServiceResult<T> success() {
        return ServiceResult.success(null);
    }

    public static <T> ServiceResult<T> from(StoreResult<T> storeResult) {
        if (storeResult.succeeded()) {
            return ServiceResult.success(storeResult.getContent());
        }
        return switch (storeResult.reason()) {
            case StoreFailure.Reason.NOT_FOUND -> ServiceResult.notFound(storeResult.getFailureDetail());
            case StoreFailure.Reason.ALREADY_EXISTS, StoreFailure.Reason.ALREADY_LEASED -> ServiceResult.conflict(storeResult.getFailureDetail());
            default -> ServiceResult.badRequest(storeResult.getFailureDetail());
        };
    }

    public static <T> ServiceResult<T> from(CommandResult commandResult) {
        if (commandResult.succeeded()) {
            return ServiceResult.success();
        }
        return switch (commandResult.reason()) {
            default -> throw new IncompatibleClassChangeError();
            case CommandFailure.Reason.NOT_FOUND -> ServiceResult.notFound(commandResult.getFailureDetail());
            case CommandFailure.Reason.CONFLICT -> ServiceResult.conflict(commandResult.getFailureDetail());
            case CommandFailure.Reason.NOT_EXECUTABLE -> ServiceResult.badRequest(commandResult.getFailureDetail());
        };
    }

    public static <T> ServiceResult<T> fromFailure(StoreResult<?> storeResult) {
        if (storeResult.succeeded()) {
            throw new IllegalArgumentException("Can only use this method when the argument is a failed result!");
        }
        return switch (storeResult.reason()) {
            case StoreFailure.Reason.NOT_FOUND -> ServiceResult.notFound(storeResult.getFailureDetail());
            case StoreFailure.Reason.ALREADY_EXISTS -> ServiceResult.conflict(storeResult.getFailureDetail());
            default -> ServiceResult.badRequest(storeResult.getFailureDetail());
        };
    }

    public static <T> ServiceResult<T> unauthorized(String message) {
        return new ServiceResult<Object>(null, new ServiceFailure(List.of(message), ServiceFailure.Reason.UNAUTHORIZED));
    }

    public ServiceFailure.Reason reason() {
        return ((ServiceFailure)this.getFailure()).getReason();
    }

    @NotNull
    protected <R1 extends AbstractResult<C1, ServiceFailure, R1>, C1> R1 newInstance(@Nullable C1 content, @Nullable ServiceFailure failure) {
        return (R1)((Object)new ServiceResult<C1>(content, failure));
    }
}

