/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.service.spi.result;

import java.util.List;
import org.eclipse.edc.service.spi.result.ServiceFailure;
import org.eclipse.edc.spi.result.AbstractResult;
import org.eclipse.edc.spi.result.Failure;

public class ServiceResult<T>
extends AbstractResult<T, ServiceFailure> {
    protected ServiceResult(T content, ServiceFailure failure) {
        super(content, (Failure)failure);
    }

    public static <T> ServiceResult<T> success(T content) {
        return new ServiceResult<T>(content, null);
    }

    public static <T> ServiceResult<T> conflict(String message) {
        return new ServiceResult<Object>(null, new ServiceFailure(List.of(message), ServiceFailure.Reason.CONFLICT));
    }

    public static <T> ServiceResult<T> notFound(String message) {
        return new ServiceResult<Object>(null, new ServiceFailure(List.of(message), ServiceFailure.Reason.NOT_FOUND));
    }

    public static <T> ServiceResult<T> badRequest(String ... message) {
        return ServiceResult.badRequest(List.of(message));
    }

    public static <T> ServiceResult<T> badRequest(List<String> messages) {
        return new ServiceResult<Object>(null, new ServiceFailure(messages, ServiceFailure.Reason.BAD_REQUEST));
    }

    public ServiceFailure.Reason reason() {
        return ((ServiceFailure)this.getFailure()).getReason();
    }
}

