/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.rql.model;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ParsedPlaceholder
implements CharSequence {
    private static final String PREFIX_GROUP = "prefix";
    private static final String NAME_GROUP = "name";
    private static final String COLON = ":";
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("(?<prefix>[a-z]+):(?<name>.+)");
    private final String value;
    private final String prefix;
    private final String name;

    private ParsedPlaceholder(String prefix, String name) {
        this.value = String.format("%s:%s", prefix, name);
        this.prefix = prefix;
        this.name = name;
    }

    public static ParsedPlaceholder of(CharSequence placeholderWithPrefix) {
        if (null == placeholderWithPrefix) {
            throw new NullPointerException("The placeholderWithPrefix must not be null!");
        }
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(placeholderWithPrefix);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Placeholder was not in expected format <prefix:name>!");
        }
        return new ParsedPlaceholder(matcher.group(PREFIX_GROUP), matcher.group(NAME_GROUP));
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.value.subSequence(start, end);
    }

    public boolean equals(Object other) {
        if (other instanceof CharSequence) {
            return Objects.equals(this.value, other.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public String toString() {
        return this.value;
    }
}

