/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.rql.model.predicates.ast;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.ditto.rql.model.predicates.ast.Node;
import org.eclipse.ditto.rql.model.predicates.ast.PredicateVisitor;
import org.eclipse.ditto.rql.model.predicates.ast.SuperNode;

public final class LogicalNode
extends SuperNode {
    private final String name;
    private final Type type;

    public LogicalNode(String name) {
        this.name = Objects.requireNonNull(name);
        this.type = Type.byName(name);
    }

    public LogicalNode(Type type) {
        this.type = type;
        this.name = type.getName();
    }

    public LogicalNode(Type type, Node ... subNodes) {
        this(type, Arrays.asList(subNodes));
    }

    public LogicalNode(Type type, Collection<Node> subNodes) {
        this.type = type;
        this.name = type.getName();
        this.getChildren().addAll(subNodes);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public void accept(PredicateVisitor predicateVisitor) {
        predicateVisitor.visit(this);
    }

    @Override
    public String toString() {
        return "LogicalNode [name=" + this.name + ", type=" + (Object)((Object)this.type) + ", children=" + this.getChildren() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogicalNode other = (LogicalNode)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.type == other.type;
    }

    public static enum Type {
        AND("and"),
        OR("or"),
        NOT("not");

        private final String name;
        private static Map<String, Type> nameToType;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Type byName(String name) {
            Objects.requireNonNull(name);
            Type type = nameToType.get(name);
            if (type == null) {
                throw new IllegalArgumentException("No type found with name: " + name);
            }
            return type;
        }

        static {
            nameToType = new HashMap<String, Type>();
            for (Type type : Type.values()) {
                nameToType.put(type.getName(), type);
            }
        }
    }
}

