/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.rql.model.predicates.ast;

import java.util.Objects;
import javax.annotation.Nullable;
import org.eclipse.ditto.rql.model.predicates.ast.Node;
import org.eclipse.ditto.rql.model.predicates.ast.PredicateVisitor;

abstract class ComparisonNode<T extends Enum<T>, V>
implements Node {
    private final T comparisonType;
    private final String comparisonProperty;
    @Nullable
    private final V comparisonValue;

    ComparisonNode(T comparisonType, String comparisonProperty, @Nullable V comparisonValue) {
        this.comparisonType = comparisonType;
        this.comparisonProperty = Objects.requireNonNull(comparisonProperty);
        this.comparisonValue = comparisonValue;
    }

    public T getComparisonType() {
        return this.comparisonType;
    }

    public String getComparisonProperty() {
        return this.comparisonProperty;
    }

    @Nullable
    public V getComparisonValue() {
        return this.comparisonValue;
    }

    @Override
    public void accept(PredicateVisitor predicateVisitor) {
        predicateVisitor.visit(this);
    }

    public String toString() {
        return "ComparisonNode [comparisonType=" + this.comparisonType + ", comparisonValue=" + this.comparisonValue + ", comparisonProperty=" + this.comparisonProperty + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.comparisonProperty == null ? 0 : this.comparisonProperty.hashCode());
        result = 31 * result + (this.comparisonType == null ? 0 : ((Enum)this.comparisonType).hashCode());
        result = 31 * result + (this.comparisonValue == null ? 0 : this.comparisonValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComparisonNode other = (ComparisonNode)obj;
        if (this.comparisonProperty == null ? other.comparisonProperty != null : !this.comparisonProperty.equals(other.comparisonProperty)) {
            return false;
        }
        if (this.comparisonType == null ? other.comparisonType != null : !((Enum)this.comparisonType).equals(other.comparisonType)) {
            return false;
        }
        if (this.comparisonValue == null) {
            return other.comparisonValue == null;
        }
        return this.comparisonValue.equals(other.comparisonValue);
    }
}

