/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.placeholders;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.placeholders.TopicPathPlaceholder;

@Immutable
final class ImmutableTopicPathPlaceholder
implements TopicPathPlaceholder {
    static final ImmutableTopicPathPlaceholder INSTANCE = new ImmutableTopicPathPlaceholder();
    private static final String FULL_PLACEHOLDER = "full";
    private static final String NAMESPACE_PLACEHOLDER = "namespace";
    private static final String ENTITY_NAME_PLACEHOLDER = "entityName";
    private static final String GROUP_PLACEHOLDER = "group";
    private static final String CHANNEL_PLACEHOLDER = "channel";
    private static final String CRITERION_PLACEHOLDER = "criterion";
    private static final String ACTION_PLACEHOLDER = "action";
    private static final String SUBJECT_PLACEHOLDER = "subject";
    private static final String ACTION_OR_SUBJECT_PLACEHOLDER = "action-subject";
    private static final List<String> SUPPORTED = Collections.unmodifiableList(Arrays.asList("full", "namespace", "entityName", "group", "channel", "criterion", "action", "subject", "action-subject"));

    private ImmutableTopicPathPlaceholder() {
    }

    public String getPrefix() {
        return "topic";
    }

    public List<String> getSupportedNames() {
        return SUPPORTED;
    }

    public boolean supports(String name) {
        return SUPPORTED.contains(name);
    }

    public List<String> resolveValues(TopicPath topicPath, String placeholder) {
        ConditionChecker.argumentNotEmpty((CharSequence)placeholder, (String)"placeholder");
        switch (placeholder) {
            case "namespace": {
                return Collections.singletonList(topicPath.getNamespace());
            }
            case "entityName": {
                return Collections.singletonList(topicPath.getEntityName());
            }
            case "group": {
                return Collections.singletonList(topicPath.getGroup().getName());
            }
            case "channel": {
                return Collections.singletonList(topicPath.getChannel().getName());
            }
            case "criterion": {
                return Collections.singletonList(topicPath.getCriterion().getName());
            }
            case "action": {
                return topicPath.getAction().map(TopicPath.Action::getName).map(Collections::singletonList).orElseGet(Collections::emptyList);
            }
            case "subject": {
                return topicPath.getSubject().map(Collections::singletonList).orElseGet(Collections::emptyList);
            }
            case "action-subject": {
                return Optional.ofNullable(topicPath.getSubject().orElseGet(() -> topicPath.getAction().map(TopicPath.Action::getName).orElse(null))).map(Collections::singletonList).orElseGet(Collections::emptyList);
            }
            case "full": {
                return Collections.singletonList(topicPath.getPath());
            }
        }
        return Collections.emptyList();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

