/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.placeholders;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.signals.WithResource;
import org.eclipse.ditto.protocol.placeholders.ResourcePlaceholder;

@Immutable
final class ImmutableResourcePlaceholder
implements ResourcePlaceholder {
    static final ImmutableResourcePlaceholder INSTANCE = new ImmutableResourcePlaceholder();
    private static final String TYPE_PLACEHOLDER = "type";
    private static final String PATH_PLACEHOLDER = "path";
    private static final List<String> SUPPORTED = Collections.unmodifiableList(Arrays.asList("type", "path"));

    private ImmutableResourcePlaceholder() {
    }

    public String getPrefix() {
        return "resource";
    }

    public List<String> getSupportedNames() {
        return SUPPORTED;
    }

    public boolean supports(String name) {
        return SUPPORTED.contains(name);
    }

    public List<String> resolveValues(WithResource withResource, String placeholder) {
        ConditionChecker.argumentNotEmpty((CharSequence)placeholder, (String)"placeholder");
        switch (placeholder) {
            case "type": {
                return Collections.singletonList(withResource.getResourceType());
            }
            case "path": {
                return Collections.singletonList(withResource.getResourcePath().toString());
            }
        }
        return Collections.emptyList();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

