/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.mappingstrategies.AbstractSearchMappingStrategies;
import org.eclipse.ditto.thingsearch.model.signals.commands.ThingSearchCommand;
import org.eclipse.ditto.thingsearch.model.signals.commands.subscription.CancelSubscription;
import org.eclipse.ditto.thingsearch.model.signals.commands.subscription.CreateSubscription;
import org.eclipse.ditto.thingsearch.model.signals.commands.subscription.RequestFromSubscription;

final class ThingSearchCommandMappingStrategies
extends AbstractSearchMappingStrategies<ThingSearchCommand<?>> {
    private static final ThingSearchCommandMappingStrategies INSTANCE = new ThingSearchCommandMappingStrategies();

    private ThingSearchCommandMappingStrategies() {
        super(ThingSearchCommandMappingStrategies.initMappingStrategies());
    }

    public static ThingSearchCommandMappingStrategies getInstance() {
        return INSTANCE;
    }

    private static Map<String, JsonifiableMapper<ThingSearchCommand<?>>> initMappingStrategies() {
        HashMap mappingStrategies = new HashMap();
        mappingStrategies.put("thing-search.commands:subscribe", adaptable -> CreateSubscription.of((String)ThingSearchCommandMappingStrategies.filterFrom(adaptable), (String)ThingSearchCommandMappingStrategies.optionsFrom(adaptable), (JsonFieldSelector)ThingSearchCommandMappingStrategies.selectedFieldsFrom(adaptable), ThingSearchCommandMappingStrategies.namespacesFrom(adaptable), (DittoHeaders)ThingSearchCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("thing-search.commands:cancel", adaptable -> CancelSubscription.of((String)Objects.requireNonNull(ThingSearchCommandMappingStrategies.subscriptionIdFrom(adaptable)), (DittoHeaders)ThingSearchCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("thing-search.commands:request", adaptable -> RequestFromSubscription.of((String)Objects.requireNonNull(ThingSearchCommandMappingStrategies.subscriptionIdFrom(adaptable)), (long)ThingSearchCommandMappingStrategies.demandFrom(adaptable), (DittoHeaders)ThingSearchCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        return mappingStrategies;
    }

    private static Set<String> namespacesFrom(Adaptable adaptable) {
        return ThingSearchCommandMappingStrategies.getFromValue(adaptable, CreateSubscription.JsonFields.NAMESPACES).map(array -> array.stream().map(JsonValue::asString).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    @Nullable
    private static String filterFrom(Adaptable adaptable) {
        return ThingSearchCommandMappingStrategies.getFromValue(adaptable, CreateSubscription.JsonFields.FILTER).orElse(null);
    }

    @Nullable
    private static String optionsFrom(Adaptable adaptable) {
        return ThingSearchCommandMappingStrategies.getFromValue(adaptable, CreateSubscription.JsonFields.OPTIONS).orElse(null);
    }

    private static long demandFrom(Adaptable adaptable) {
        return ThingSearchCommandMappingStrategies.getFromValue(adaptable, RequestFromSubscription.JsonFields.DEMAND).orElse(0L);
    }
}

