/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.policies.model.PolicyId;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.mappingstrategies.AdaptableToSignalMapper;
import org.eclipse.ditto.protocol.mappingstrategies.MappingStrategies;
import org.eclipse.ditto.things.model.Attributes;
import org.eclipse.ditto.things.model.Feature;
import org.eclipse.ditto.things.model.FeatureDefinition;
import org.eclipse.ditto.things.model.FeatureProperties;
import org.eclipse.ditto.things.model.Features;
import org.eclipse.ditto.things.model.ThingDefinition;
import org.eclipse.ditto.things.model.ThingId;
import org.eclipse.ditto.things.model.signals.commands.query.RetrieveAttributeResponse;
import org.eclipse.ditto.things.model.signals.commands.query.RetrieveAttributesResponse;
import org.eclipse.ditto.things.model.signals.commands.query.RetrieveFeatureDefinitionResponse;
import org.eclipse.ditto.things.model.signals.commands.query.RetrieveFeatureDesiredPropertiesResponse;
import org.eclipse.ditto.things.model.signals.commands.query.RetrieveFeatureDesiredPropertyResponse;
import org.eclipse.ditto.things.model.signals.commands.query.RetrieveFeaturePropertiesResponse;
import org.eclipse.ditto.things.model.signals.commands.query.RetrieveFeaturePropertyResponse;
import org.eclipse.ditto.things.model.signals.commands.query.RetrieveFeatureResponse;
import org.eclipse.ditto.things.model.signals.commands.query.RetrieveFeaturesResponse;
import org.eclipse.ditto.things.model.signals.commands.query.RetrievePolicyIdResponse;
import org.eclipse.ditto.things.model.signals.commands.query.RetrieveThingDefinitionResponse;
import org.eclipse.ditto.things.model.signals.commands.query.RetrieveThingResponse;
import org.eclipse.ditto.things.model.signals.commands.query.ThingQueryCommandResponse;

final class ThingQueryCommandResponseMappingStrategies
implements MappingStrategies<ThingQueryCommandResponse<?>> {
    private static final ThingQueryCommandResponseMappingStrategies INSTANCE = new ThingQueryCommandResponseMappingStrategies();
    private final Map<String, JsonifiableMapper<? extends ThingQueryCommandResponse<?>>> mappingStrategies = Collections.unmodifiableMap(ThingQueryCommandResponseMappingStrategies.initMappingStrategies());

    private ThingQueryCommandResponseMappingStrategies() {
    }

    static ThingQueryCommandResponseMappingStrategies getInstance() {
        return INSTANCE;
    }

    private static Map<String, JsonifiableMapper<? extends ThingQueryCommandResponse<?>>> initMappingStrategies() {
        Stream<AdaptableToSignalMapper<RetrievePolicyIdResponse>> mappers = Stream.builder().add(AdaptableToSignalMapper.of("things.responses:retrieveThing", context -> {
            JsonObject thingJsonObject = context.getPayloadValueAsJsonObjectOrThrow();
            return RetrieveThingResponse.newInstance((ThingId)context.getThingId(), (JsonObject)thingJsonObject, (String)thingJsonObject.toString(), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders());
        })).add(AdaptableToSignalMapper.of("things.responses:retrieveAttributes", context -> RetrieveAttributesResponse.newInstance((ThingId)context.getThingId(), (Attributes)context.getAttributesOrThrow(), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders()))).add(AdaptableToSignalMapper.of("things.responses:retrieveAttribute", context -> RetrieveAttributeResponse.newInstance((ThingId)context.getThingId(), (JsonPointer)context.getAttributePointerOrThrow(), (JsonValue)context.getAttributeValueOrThrow(), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders()))).add(AdaptableToSignalMapper.of("things.responses:retrieveDefinition", context -> RetrieveThingDefinitionResponse.newInstance((ThingId)context.getThingId(), (ThingDefinition)context.getThingDefinitionOrThrow(), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders()))).add(AdaptableToSignalMapper.of("things.responses:retrieveFeatures", context -> RetrieveFeaturesResponse.newInstance((ThingId)context.getThingId(), (Features)context.getFeaturesOrThrow(), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders()))).add(AdaptableToSignalMapper.of("things.responses:retrieveFeature", context -> RetrieveFeatureResponse.newInstance((ThingId)context.getThingId(), (Feature)context.getFeatureOrThrow(), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders()))).add(AdaptableToSignalMapper.of("things.responses:retrieveFeatureDefinition", context -> {
            FeatureDefinition featureDefinition = context.getFeatureDefinitionOrThrow();
            return RetrieveFeatureDefinitionResponse.newInstance((ThingId)context.getThingId(), (String)context.getFeatureIdOrThrow(), (JsonArray)((JsonArray)featureDefinition.toJson()), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders());
        })).add(AdaptableToSignalMapper.of("things.responses:retrieveFeatureProperties", context -> RetrieveFeaturePropertiesResponse.newInstance((ThingId)context.getThingId(), (String)context.getFeatureIdOrThrow(), (FeatureProperties)context.getFeaturePropertiesOrThrow(), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders()))).add(AdaptableToSignalMapper.of("things.responses:retrieveFeatureDesiredProperties", context -> RetrieveFeatureDesiredPropertiesResponse.newInstance((ThingId)context.getThingId(), (CharSequence)context.getFeatureIdOrThrow(), (FeatureProperties)context.getFeaturePropertiesOrThrow(), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders()))).add(AdaptableToSignalMapper.of("things.responses:retrieveFeatureProperty", context -> RetrieveFeaturePropertyResponse.newInstance((ThingId)context.getThingId(), (String)context.getFeatureIdOrThrow(), (JsonPointer)context.getFeaturePropertyPointerOrThrow(), (JsonValue)context.getFeaturePropertyValueOrThrow(), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders()))).add(AdaptableToSignalMapper.of("things.responses:retrieveFeatureDesiredProperty", context -> RetrieveFeatureDesiredPropertyResponse.newInstance((ThingId)context.getThingId(), (CharSequence)context.getFeatureIdOrThrow(), (JsonPointer)context.getFeatureDesiredPropertyPointerOrThrow(), (JsonValue)context.getFeaturePropertyValueOrThrow(), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders()))).add(AdaptableToSignalMapper.of("things.responses:retrievePolicyId", context -> RetrievePolicyIdResponse.newInstance((ThingId)context.getThingId(), (PolicyId)context.getPolicyIdOrThrow(), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders()))).build();
        return mappers.collect(Collectors.toMap(AdaptableToSignalMapper::getSignalType, Function.identity()));
    }

    @Override
    @Nullable
    public JsonifiableMapper<ThingQueryCommandResponse<?>> find(String type) {
        return this.mappingStrategies.get(type);
    }
}

