/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.mappingstrategies.AbstractThingMappingStrategies;
import org.eclipse.ditto.things.model.ThingId;
import org.eclipse.ditto.things.model.signals.commands.query.RetrieveAttribute;
import org.eclipse.ditto.things.model.signals.commands.query.RetrieveAttributes;
import org.eclipse.ditto.things.model.signals.commands.query.RetrieveFeature;
import org.eclipse.ditto.things.model.signals.commands.query.RetrieveFeatureDefinition;
import org.eclipse.ditto.things.model.signals.commands.query.RetrieveFeatureDesiredProperties;
import org.eclipse.ditto.things.model.signals.commands.query.RetrieveFeatureDesiredProperty;
import org.eclipse.ditto.things.model.signals.commands.query.RetrieveFeatureProperties;
import org.eclipse.ditto.things.model.signals.commands.query.RetrieveFeatureProperty;
import org.eclipse.ditto.things.model.signals.commands.query.RetrieveFeatures;
import org.eclipse.ditto.things.model.signals.commands.query.RetrievePolicyId;
import org.eclipse.ditto.things.model.signals.commands.query.RetrieveThing;
import org.eclipse.ditto.things.model.signals.commands.query.RetrieveThingDefinition;
import org.eclipse.ditto.things.model.signals.commands.query.ThingQueryCommand;

final class ThingQueryCommandMappingStrategies
extends AbstractThingMappingStrategies<ThingQueryCommand<?>> {
    private static final ThingQueryCommandMappingStrategies INSTANCE = new ThingQueryCommandMappingStrategies();

    private ThingQueryCommandMappingStrategies() {
        super(ThingQueryCommandMappingStrategies.initMappingStrategies());
    }

    public static ThingQueryCommandMappingStrategies getInstance() {
        return INSTANCE;
    }

    private static Map<String, JsonifiableMapper<ThingQueryCommand<?>>> initMappingStrategies() {
        HashMap mappingStrategies = new HashMap();
        mappingStrategies.put("things.commands:retrieveThing", adaptable -> RetrieveThing.getBuilder((ThingId)ThingQueryCommandMappingStrategies.thingIdFrom(adaptable), (DittoHeaders)ThingQueryCommandMappingStrategies.dittoHeadersFrom(adaptable)).withSelectedFields(ThingQueryCommandMappingStrategies.selectedFieldsFrom(adaptable)).build());
        mappingStrategies.put("things.commands:retrieveAttributes", adaptable -> RetrieveAttributes.of((ThingId)ThingQueryCommandMappingStrategies.thingIdFrom(adaptable), (JsonFieldSelector)ThingQueryCommandMappingStrategies.selectedFieldsFrom(adaptable), (DittoHeaders)ThingQueryCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("things.commands:retrieveAttribute", adaptable -> RetrieveAttribute.of((ThingId)ThingQueryCommandMappingStrategies.thingIdFrom(adaptable), (JsonPointer)ThingQueryCommandMappingStrategies.attributePointerFrom(adaptable), (DittoHeaders)ThingQueryCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("things.commands:retrieveDefinition", adaptable -> RetrieveThingDefinition.of((ThingId)ThingQueryCommandMappingStrategies.thingIdFrom(adaptable), (DittoHeaders)ThingQueryCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("things.commands:retrieveFeatures", adaptable -> RetrieveFeatures.of((ThingId)ThingQueryCommandMappingStrategies.thingIdFrom(adaptable), (JsonFieldSelector)ThingQueryCommandMappingStrategies.selectedFieldsFrom(adaptable), (DittoHeaders)ThingQueryCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("things.commands:retrieveFeature", adaptable -> RetrieveFeature.of((ThingId)ThingQueryCommandMappingStrategies.thingIdFrom(adaptable), (String)ThingQueryCommandMappingStrategies.featureIdFrom(adaptable), (JsonFieldSelector)ThingQueryCommandMappingStrategies.selectedFieldsFrom(adaptable), (DittoHeaders)ThingQueryCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("things.commands:retrieveFeatureDefinition", adaptable -> RetrieveFeatureDefinition.of((ThingId)ThingQueryCommandMappingStrategies.thingIdFrom(adaptable), (String)ThingQueryCommandMappingStrategies.featureIdFrom(adaptable), (DittoHeaders)ThingQueryCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("things.commands:retrieveFeatureProperties", adaptable -> RetrieveFeatureProperties.of((ThingId)ThingQueryCommandMappingStrategies.thingIdFrom(adaptable), (String)ThingQueryCommandMappingStrategies.featureIdFrom(adaptable), (JsonFieldSelector)ThingQueryCommandMappingStrategies.selectedFieldsFrom(adaptable), (DittoHeaders)ThingQueryCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("things.commands:retrieveFeatureProperty", adaptable -> RetrieveFeatureProperty.of((ThingId)ThingQueryCommandMappingStrategies.thingIdFrom(adaptable), (String)ThingQueryCommandMappingStrategies.featureIdFrom(adaptable), (JsonPointer)ThingQueryCommandMappingStrategies.featurePropertyPointerFrom(adaptable), (DittoHeaders)ThingQueryCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("things.commands:retrieveFeatureDesiredProperties", adaptable -> RetrieveFeatureDesiredProperties.of((ThingId)ThingQueryCommandMappingStrategies.thingIdFrom(adaptable), (CharSequence)ThingQueryCommandMappingStrategies.featureIdFrom(adaptable), (JsonFieldSelector)ThingQueryCommandMappingStrategies.selectedFieldsFrom(adaptable), (DittoHeaders)ThingQueryCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("things.commands:retrieveFeatureDesiredProperty", adaptable -> RetrieveFeatureDesiredProperty.of((ThingId)ThingQueryCommandMappingStrategies.thingIdFrom(adaptable), (String)ThingQueryCommandMappingStrategies.featureIdFrom(adaptable), (JsonPointer)ThingQueryCommandMappingStrategies.featurePropertyPointerFrom(adaptable), (DittoHeaders)ThingQueryCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("things.commands:retrievePolicyId", adaptable -> RetrievePolicyId.of((ThingId)ThingQueryCommandMappingStrategies.thingIdFrom(adaptable), (DittoHeaders)ThingQueryCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        return mappingStrategies;
    }
}

