/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.policies.model.PolicyId;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.mappingstrategies.AdaptableToSignalMapper;
import org.eclipse.ditto.protocol.mappingstrategies.MappingStrategies;
import org.eclipse.ditto.things.model.Attributes;
import org.eclipse.ditto.things.model.Feature;
import org.eclipse.ditto.things.model.FeatureDefinition;
import org.eclipse.ditto.things.model.FeatureProperties;
import org.eclipse.ditto.things.model.Features;
import org.eclipse.ditto.things.model.Thing;
import org.eclipse.ditto.things.model.ThingDefinition;
import org.eclipse.ditto.things.model.ThingId;
import org.eclipse.ditto.things.model.ThingsModelFactory;
import org.eclipse.ditto.things.model.signals.commands.modify.CreateThingResponse;
import org.eclipse.ditto.things.model.signals.commands.modify.DeleteAttributeResponse;
import org.eclipse.ditto.things.model.signals.commands.modify.DeleteAttributesResponse;
import org.eclipse.ditto.things.model.signals.commands.modify.DeleteFeatureDefinitionResponse;
import org.eclipse.ditto.things.model.signals.commands.modify.DeleteFeatureDesiredPropertiesResponse;
import org.eclipse.ditto.things.model.signals.commands.modify.DeleteFeatureDesiredPropertyResponse;
import org.eclipse.ditto.things.model.signals.commands.modify.DeleteFeaturePropertiesResponse;
import org.eclipse.ditto.things.model.signals.commands.modify.DeleteFeaturePropertyResponse;
import org.eclipse.ditto.things.model.signals.commands.modify.DeleteFeatureResponse;
import org.eclipse.ditto.things.model.signals.commands.modify.DeleteFeaturesResponse;
import org.eclipse.ditto.things.model.signals.commands.modify.DeleteThingDefinitionResponse;
import org.eclipse.ditto.things.model.signals.commands.modify.DeleteThingResponse;
import org.eclipse.ditto.things.model.signals.commands.modify.ModifyAttributeResponse;
import org.eclipse.ditto.things.model.signals.commands.modify.ModifyAttributesResponse;
import org.eclipse.ditto.things.model.signals.commands.modify.ModifyFeatureDefinitionResponse;
import org.eclipse.ditto.things.model.signals.commands.modify.ModifyFeatureDesiredPropertiesResponse;
import org.eclipse.ditto.things.model.signals.commands.modify.ModifyFeatureDesiredPropertyResponse;
import org.eclipse.ditto.things.model.signals.commands.modify.ModifyFeaturePropertiesResponse;
import org.eclipse.ditto.things.model.signals.commands.modify.ModifyFeaturePropertyResponse;
import org.eclipse.ditto.things.model.signals.commands.modify.ModifyFeatureResponse;
import org.eclipse.ditto.things.model.signals.commands.modify.ModifyFeaturesResponse;
import org.eclipse.ditto.things.model.signals.commands.modify.ModifyPolicyIdResponse;
import org.eclipse.ditto.things.model.signals.commands.modify.ModifyThingDefinitionResponse;
import org.eclipse.ditto.things.model.signals.commands.modify.ModifyThingResponse;
import org.eclipse.ditto.things.model.signals.commands.modify.ThingModifyCommandResponse;

final class ThingModifyCommandResponseMappingStrategies
implements MappingStrategies<ThingModifyCommandResponse<?>> {
    private static final ThingModifyCommandResponseMappingStrategies INSTANCE = new ThingModifyCommandResponseMappingStrategies();
    private final Map<String, JsonifiableMapper<? extends ThingModifyCommandResponse<?>>> mappingStrategies = Collections.unmodifiableMap(ThingModifyCommandResponseMappingStrategies.initMappingStrategies());

    private ThingModifyCommandResponseMappingStrategies() {
    }

    static ThingModifyCommandResponseMappingStrategies getInstance() {
        return INSTANCE;
    }

    private static Map<String, JsonifiableMapper<? extends ThingModifyCommandResponse<?>>> initMappingStrategies() {
        Stream.Builder<AdaptableToSignalMapper<ThingModifyCommandResponse<?>>> streamBuilder = Stream.builder();
        ThingModifyCommandResponseMappingStrategies.addTopLevelResponseMappers(streamBuilder);
        ThingModifyCommandResponseMappingStrategies.addAttributeResponseMappers(streamBuilder);
        ThingModifyCommandResponseMappingStrategies.addDefinitionResponseMappers(streamBuilder);
        ThingModifyCommandResponseMappingStrategies.addFeatureResponseMappers(streamBuilder);
        Stream<AdaptableToSignalMapper<ThingModifyCommandResponse<?>>> mappers = streamBuilder.build();
        return mappers.collect(Collectors.toMap(AdaptableToSignalMapper::getSignalType, Function.identity()));
    }

    private static void addTopLevelResponseMappers(Consumer<AdaptableToSignalMapper<? extends ThingModifyCommandResponse<?>>> streamBuilder) {
        streamBuilder.accept(AdaptableToSignalMapper.of("things.responses:createThing", context -> CreateThingResponse.newInstance((Thing)context.getThingOrThrow(), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("things.responses:modifyThing", context -> ModifyThingResponse.newInstance((ThingId)context.getThingId(), (Thing)context.getThing().orElse(null), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("things.responses:deleteThing", context -> DeleteThingResponse.newInstance((ThingId)context.getThingId(), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("things.responses:modifyPolicyId", context -> ModifyPolicyIdResponse.newInstance((ThingId)context.getThingId(), (PolicyId)context.getPolicyId().orElse(null), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders())));
    }

    private static void addAttributeResponseMappers(Consumer<AdaptableToSignalMapper<? extends ThingModifyCommandResponse<?>>> streamBuilder) {
        streamBuilder.accept(AdaptableToSignalMapper.of("things.responses:modifyAttributes", context -> ModifyAttributesResponse.newInstance((ThingId)context.getThingId(), (Attributes)context.getAttributes().orElseGet(ThingsModelFactory::nullAttributes), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("things.responses:deleteAttributes", context -> DeleteAttributesResponse.newInstance((ThingId)context.getThingId(), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("things.responses:modifyAttribute", context -> ModifyAttributeResponse.newInstance((ThingId)context.getThingId(), (JsonPointer)context.getAttributePointerOrThrow(), (JsonValue)context.getAttributeValue().orElse(null), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("things.responses:deleteAttribute", context -> DeleteAttributeResponse.newInstance((ThingId)context.getThingId(), (JsonPointer)context.getAttributePointerOrThrow(), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders())));
    }

    private static void addDefinitionResponseMappers(Consumer<AdaptableToSignalMapper<? extends ThingModifyCommandResponse<?>>> streamBuilder) {
        streamBuilder.accept(AdaptableToSignalMapper.of("things.responses:modifyDefinition", context -> ModifyThingDefinitionResponse.newInstance((ThingId)context.getThingId(), (ThingDefinition)context.getThingDefinition().orElse(null), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("things.responses:deleteDefinition", context -> DeleteThingDefinitionResponse.newInstance((ThingId)context.getThingId(), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders())));
    }

    private static void addFeatureResponseMappers(Consumer<AdaptableToSignalMapper<? extends ThingModifyCommandResponse<?>>> streamBuilder) {
        streamBuilder.accept(AdaptableToSignalMapper.of("things.responses:modifyFeatures", context -> ModifyFeaturesResponse.newInstance((ThingId)context.getThingId(), (Features)context.getFeatures().orElseGet(ThingsModelFactory::nullFeatures), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("things.responses:deleteFeatures", context -> DeleteFeaturesResponse.newInstance((ThingId)context.getThingId(), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("things.responses:modifyFeature", context -> ModifyFeatureResponse.newInstance((ThingId)context.getThingId(), (Feature)context.getFeature().orElse(null), (String)context.getFeatureIdOrThrow(), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("things.responses:deleteFeature", context -> DeleteFeatureResponse.newInstance((ThingId)context.getThingId(), (CharSequence)context.getFeatureIdOrThrow(), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("things.responses:modifyFeatureDefinition", context -> ModifyFeatureDefinitionResponse.newInstance((ThingId)context.getThingId(), (String)context.getFeatureIdOrThrow(), (FeatureDefinition)context.getFeatureDefinition().orElse(null), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("things.responses:deleteFeatureDefinition", context -> DeleteFeatureDefinitionResponse.newInstance((ThingId)context.getThingId(), (String)context.getFeatureIdOrThrow(), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("things.responses:modifyFeatureProperties", context -> ModifyFeaturePropertiesResponse.newInstance((ThingId)context.getThingId(), (String)context.getFeatureIdOrThrow(), (FeatureProperties)context.getFeatureProperties().orElse(null), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("things.responses:deleteFeatureProperties", context -> DeleteFeaturePropertiesResponse.of((ThingId)context.getThingId(), (String)context.getFeatureIdOrThrow(), (DittoHeaders)context.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("things.responses:modifyFeatureDesiredProperties", context -> ModifyFeatureDesiredPropertiesResponse.newInstance((ThingId)context.getThingId(), (CharSequence)context.getFeatureIdOrThrow(), (FeatureProperties)context.getFeatureProperties().orElse(null), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("things.responses:deleteFeatureDesiredProperties", context -> DeleteFeatureDesiredPropertiesResponse.newInstance((ThingId)context.getThingId(), (CharSequence)context.getFeatureIdOrThrow(), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("things.responses:modifyFeatureProperty", context -> ModifyFeaturePropertyResponse.newInstance((ThingId)context.getThingId(), (String)context.getFeatureIdOrThrow(), (JsonPointer)context.getFeaturePropertyPointerOrThrow(), (JsonValue)context.getFeaturePropertyValue().orElse(null), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("things.responses:deleteFeatureProperty", context -> DeleteFeaturePropertyResponse.newInstance((ThingId)context.getThingId(), (CharSequence)context.getFeatureIdOrThrow(), (JsonPointer)context.getFeaturePropertyPointerOrThrow(), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("things.responses:modifyFeatureDesiredProperty", context -> ModifyFeatureDesiredPropertyResponse.newInstance((ThingId)context.getThingId(), (CharSequence)context.getFeatureIdOrThrow(), (JsonPointer)context.getFeatureDesiredPropertyPointerOrThrow(), (JsonValue)context.getFeaturePropertyValue().orElse(null), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("things.responses:deleteFeatureDesiredProperty", context -> DeleteFeatureDesiredPropertyResponse.newInstance((ThingId)context.getThingId(), (CharSequence)context.getFeatureIdOrThrow(), (JsonPointer)context.getFeatureDesiredPropertyPointerOrThrow(), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders())));
    }

    @Override
    @Nullable
    public JsonifiableMapper<ThingModifyCommandResponse<?>> find(String type) {
        return this.mappingStrategies.get(type);
    }
}

