/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.policies.model.PolicyId;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.mappingstrategies.AbstractThingMappingStrategies;
import org.eclipse.ditto.things.model.Attributes;
import org.eclipse.ditto.things.model.Feature;
import org.eclipse.ditto.things.model.FeatureDefinition;
import org.eclipse.ditto.things.model.FeatureProperties;
import org.eclipse.ditto.things.model.Features;
import org.eclipse.ditto.things.model.Thing;
import org.eclipse.ditto.things.model.ThingDefinition;
import org.eclipse.ditto.things.model.ThingId;
import org.eclipse.ditto.things.model.signals.commands.exceptions.ThingIdNotExplicitlySettableException;
import org.eclipse.ditto.things.model.signals.commands.modify.CreateThing;
import org.eclipse.ditto.things.model.signals.commands.modify.DeleteAttribute;
import org.eclipse.ditto.things.model.signals.commands.modify.DeleteAttributes;
import org.eclipse.ditto.things.model.signals.commands.modify.DeleteFeature;
import org.eclipse.ditto.things.model.signals.commands.modify.DeleteFeatureDefinition;
import org.eclipse.ditto.things.model.signals.commands.modify.DeleteFeatureDesiredProperties;
import org.eclipse.ditto.things.model.signals.commands.modify.DeleteFeatureDesiredProperty;
import org.eclipse.ditto.things.model.signals.commands.modify.DeleteFeatureProperties;
import org.eclipse.ditto.things.model.signals.commands.modify.DeleteFeatureProperty;
import org.eclipse.ditto.things.model.signals.commands.modify.DeleteFeatures;
import org.eclipse.ditto.things.model.signals.commands.modify.DeleteThing;
import org.eclipse.ditto.things.model.signals.commands.modify.DeleteThingDefinition;
import org.eclipse.ditto.things.model.signals.commands.modify.ModifyAttribute;
import org.eclipse.ditto.things.model.signals.commands.modify.ModifyAttributes;
import org.eclipse.ditto.things.model.signals.commands.modify.ModifyFeature;
import org.eclipse.ditto.things.model.signals.commands.modify.ModifyFeatureDefinition;
import org.eclipse.ditto.things.model.signals.commands.modify.ModifyFeatureDesiredProperties;
import org.eclipse.ditto.things.model.signals.commands.modify.ModifyFeatureDesiredProperty;
import org.eclipse.ditto.things.model.signals.commands.modify.ModifyFeatureProperties;
import org.eclipse.ditto.things.model.signals.commands.modify.ModifyFeatureProperty;
import org.eclipse.ditto.things.model.signals.commands.modify.ModifyFeatures;
import org.eclipse.ditto.things.model.signals.commands.modify.ModifyPolicyId;
import org.eclipse.ditto.things.model.signals.commands.modify.ModifyThing;
import org.eclipse.ditto.things.model.signals.commands.modify.ModifyThingDefinition;
import org.eclipse.ditto.things.model.signals.commands.modify.ThingModifyCommand;

final class ThingModifyCommandMappingStrategies
extends AbstractThingMappingStrategies<ThingModifyCommand<?>> {
    private static final ThingModifyCommandMappingStrategies INSTANCE = new ThingModifyCommandMappingStrategies();

    private ThingModifyCommandMappingStrategies() {
        super(ThingModifyCommandMappingStrategies.initMappingStrategies());
    }

    private static Map<String, JsonifiableMapper<ThingModifyCommand<?>>> initMappingStrategies() {
        HashMap mappingStrategies = new HashMap();
        ThingModifyCommandMappingStrategies.addTopLevelMappingStrategies(mappingStrategies);
        ThingModifyCommandMappingStrategies.addAttributeMappingStrategies(mappingStrategies);
        ThingModifyCommandMappingStrategies.addDefinitionMappingStrategies(mappingStrategies);
        ThingModifyCommandMappingStrategies.addFeatureMappingStrategies(mappingStrategies);
        return mappingStrategies;
    }

    private static void addTopLevelMappingStrategies(Map<String, JsonifiableMapper<ThingModifyCommand<?>>> mappingStrategies) {
        mappingStrategies.put("things.commands:createThing", ThingModifyCommandMappingStrategies::createThingFrom);
        mappingStrategies.put("things.commands:modifyThing", ThingModifyCommandMappingStrategies::modifyThingFrom);
        mappingStrategies.put("things.commands:deleteThing", adaptable -> DeleteThing.of((ThingId)ThingModifyCommandMappingStrategies.thingIdFrom(adaptable), (DittoHeaders)ThingModifyCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("things.commands:modifyPolicyId", ThingModifyCommandMappingStrategies::modifyPolicyIdFrom);
    }

    private static void addDefinitionMappingStrategies(Map<String, JsonifiableMapper<ThingModifyCommand<?>>> mappingStrategies) {
        mappingStrategies.put("things.commands:modifyDefinition", adaptable -> ModifyThingDefinition.of((ThingId)ThingModifyCommandMappingStrategies.thingIdFrom(adaptable), (ThingDefinition)ThingModifyCommandMappingStrategies.thingDefinitionFrom(adaptable), (DittoHeaders)ThingModifyCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("things.commands:deleteDefinition", adaptable -> DeleteThingDefinition.of((ThingId)ThingModifyCommandMappingStrategies.thingIdFrom(adaptable), (DittoHeaders)ThingModifyCommandMappingStrategies.dittoHeadersFrom(adaptable)));
    }

    private static void addAttributeMappingStrategies(Map<String, JsonifiableMapper<ThingModifyCommand<?>>> mappingStrategies) {
        mappingStrategies.put("things.commands:modifyAttributes", adaptable -> ModifyAttributes.of((ThingId)ThingModifyCommandMappingStrategies.thingIdFrom(adaptable), (Attributes)ThingModifyCommandMappingStrategies.attributesFrom(adaptable), (DittoHeaders)ThingModifyCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("things.commands:deleteAttributes", adaptable -> DeleteAttributes.of((ThingId)ThingModifyCommandMappingStrategies.thingIdFrom(adaptable), (DittoHeaders)ThingModifyCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("things.commands:modifyAttribute", adaptable -> ModifyAttribute.of((ThingId)ThingModifyCommandMappingStrategies.thingIdFrom(adaptable), (JsonPointer)ThingModifyCommandMappingStrategies.attributePointerFrom(adaptable), (JsonValue)ThingModifyCommandMappingStrategies.attributeValueFrom(adaptable), (DittoHeaders)ThingModifyCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("things.commands:deleteAttribute", adaptable -> DeleteAttribute.of((ThingId)ThingModifyCommandMappingStrategies.thingIdFrom(adaptable), (JsonPointer)ThingModifyCommandMappingStrategies.attributePointerFrom(adaptable), (DittoHeaders)ThingModifyCommandMappingStrategies.dittoHeadersFrom(adaptable)));
    }

    private static void addFeatureMappingStrategies(Map<String, JsonifiableMapper<ThingModifyCommand<?>>> mappingStrategies) {
        mappingStrategies.put("things.commands:modifyFeatures", adaptable -> ModifyFeatures.of((ThingId)ThingModifyCommandMappingStrategies.thingIdFrom(adaptable), (Features)ThingModifyCommandMappingStrategies.featuresFrom(adaptable), (DittoHeaders)ThingModifyCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("things.commands:deleteFeatures", adaptable -> DeleteFeatures.of((ThingId)ThingModifyCommandMappingStrategies.thingIdFrom(adaptable), (DittoHeaders)ThingModifyCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("things.commands:modifyFeature", adaptable -> ModifyFeature.of((ThingId)ThingModifyCommandMappingStrategies.thingIdFrom(adaptable), (Feature)ThingModifyCommandMappingStrategies.featureFrom(adaptable), (DittoHeaders)ThingModifyCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("things.commands:deleteFeature", adaptable -> DeleteFeature.of((ThingId)ThingModifyCommandMappingStrategies.thingIdFrom(adaptable), (String)ThingModifyCommandMappingStrategies.featureIdFrom(adaptable), (DittoHeaders)ThingModifyCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("things.commands:modifyFeatureDefinition", adaptable -> ModifyFeatureDefinition.of((ThingId)ThingModifyCommandMappingStrategies.thingIdFrom(adaptable), (String)ThingModifyCommandMappingStrategies.featureIdFrom(adaptable), (FeatureDefinition)ThingModifyCommandMappingStrategies.featureDefinitionFrom(adaptable), (DittoHeaders)ThingModifyCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("things.commands:deleteFeatureDefinition", adaptable -> DeleteFeatureDefinition.of((ThingId)ThingModifyCommandMappingStrategies.thingIdFrom(adaptable), (String)ThingModifyCommandMappingStrategies.featureIdFrom(adaptable), (DittoHeaders)ThingModifyCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("things.commands:modifyFeatureProperties", adaptable -> ModifyFeatureProperties.of((ThingId)ThingModifyCommandMappingStrategies.thingIdFrom(adaptable), (String)ThingModifyCommandMappingStrategies.featureIdFrom(adaptable), (FeatureProperties)ThingModifyCommandMappingStrategies.featurePropertiesFrom(adaptable), (DittoHeaders)ThingModifyCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("things.commands:deleteFeatureProperties", adaptable -> DeleteFeatureProperties.of((ThingId)ThingModifyCommandMappingStrategies.thingIdFrom(adaptable), (String)ThingModifyCommandMappingStrategies.featureIdFrom(adaptable), (DittoHeaders)ThingModifyCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("things.commands:modifyFeatureDesiredProperties", adaptable -> ModifyFeatureDesiredProperties.of((ThingId)ThingModifyCommandMappingStrategies.thingIdFrom(adaptable), (CharSequence)ThingModifyCommandMappingStrategies.featureIdFrom(adaptable), (FeatureProperties)ThingModifyCommandMappingStrategies.featurePropertiesFrom(adaptable), (DittoHeaders)ThingModifyCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("things.commands:deleteFeatureDesiredProperties", adaptable -> DeleteFeatureDesiredProperties.of((ThingId)ThingModifyCommandMappingStrategies.thingIdFrom(adaptable), (CharSequence)ThingModifyCommandMappingStrategies.featureIdFrom(adaptable), (DittoHeaders)ThingModifyCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("things.commands:modifyFeatureProperty", adaptable -> ModifyFeatureProperty.of((ThingId)ThingModifyCommandMappingStrategies.thingIdFrom(adaptable), (String)ThingModifyCommandMappingStrategies.featureIdFrom(adaptable), (JsonPointer)ThingModifyCommandMappingStrategies.featurePropertyPointerFrom(adaptable), (JsonValue)ThingModifyCommandMappingStrategies.featurePropertyValueFrom(adaptable), (DittoHeaders)ThingModifyCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("things.commands:deleteFeatureProperty", adaptable -> DeleteFeatureProperty.of((ThingId)ThingModifyCommandMappingStrategies.thingIdFrom(adaptable), (String)ThingModifyCommandMappingStrategies.featureIdFrom(adaptable), (JsonPointer)ThingModifyCommandMappingStrategies.featurePropertyPointerFrom(adaptable), (DittoHeaders)ThingModifyCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("things.commands:modifyFeatureDesiredProperty", adaptable -> ModifyFeatureDesiredProperty.of((ThingId)ThingModifyCommandMappingStrategies.thingIdFrom(adaptable), (CharSequence)ThingModifyCommandMappingStrategies.featureIdFrom(adaptable), (JsonPointer)ThingModifyCommandMappingStrategies.featurePropertyPointerFrom(adaptable), (JsonValue)ThingModifyCommandMappingStrategies.featurePropertyValueFrom(adaptable), (DittoHeaders)ThingModifyCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("things.commands:deleteFeatureDesiredProperty", adaptable -> DeleteFeatureDesiredProperty.of((ThingId)ThingModifyCommandMappingStrategies.thingIdFrom(adaptable), (CharSequence)ThingModifyCommandMappingStrategies.featureIdFrom(adaptable), (JsonPointer)ThingModifyCommandMappingStrategies.featurePropertyPointerFrom(adaptable), (DittoHeaders)ThingModifyCommandMappingStrategies.dittoHeadersFrom(adaptable)));
    }

    static ThingModifyCommandMappingStrategies getInstance() {
        return INSTANCE;
    }

    private static CreateThing createThingFrom(Adaptable adaptable) {
        return CreateThing.of((Thing)ThingModifyCommandMappingStrategies.thingToCreateOrModifyFrom(adaptable), (JsonObject)ThingModifyCommandMappingStrategies.initialPolicyForCreateThingFrom(adaptable), (String)ThingModifyCommandMappingStrategies.policyIdOrPlaceholderForCreateThingFrom(adaptable), (DittoHeaders)ThingModifyCommandMappingStrategies.dittoHeadersFrom(adaptable));
    }

    private static ModifyThing modifyThingFrom(Adaptable adaptable) {
        Thing thing = ThingModifyCommandMappingStrategies.thingToCreateOrModifyFrom(adaptable);
        ThingId thingId = (ThingId)thing.getEntityId().orElseThrow(() -> new IllegalStateException("ID should have been enforced in thingToCreateOrModifyFrom"));
        return ModifyThing.of((ThingId)thingId, (Thing)thing, (JsonObject)ThingModifyCommandMappingStrategies.initialPolicyForModifyThingFrom(adaptable), (String)ThingModifyCommandMappingStrategies.policyIdOrPlaceholderForModifyThingFrom(adaptable), (DittoHeaders)ThingModifyCommandMappingStrategies.dittoHeadersFrom(adaptable));
    }

    private static Thing thingToCreateOrModifyFrom(Adaptable adaptable) {
        Thing thing = ThingModifyCommandMappingStrategies.thingFrom(adaptable);
        Optional thingIdOptional = thing.getEntityId();
        ThingId thingIdFromTopic = ThingModifyCommandMappingStrategies.thingIdFrom(adaptable);
        if (thingIdOptional.isPresent()) {
            if (!((ThingId)thingIdOptional.get()).equals((Object)thingIdFromTopic)) {
                throw (ThingIdNotExplicitlySettableException)ThingIdNotExplicitlySettableException.forDittoProtocol().dittoHeaders(adaptable.getDittoHeaders()).build();
            }
        } else {
            return thing.toBuilder().setId(thingIdFromTopic).build();
        }
        return thing;
    }

    private static ModifyPolicyId modifyPolicyIdFrom(Adaptable adaptable) {
        ThingId thingId = ThingModifyCommandMappingStrategies.thingIdFrom(adaptable);
        PolicyId policyId = ThingModifyCommandMappingStrategies.policyIdFrom(adaptable);
        return ModifyPolicyId.of((ThingId)thingId, (PolicyId)policyId, (DittoHeaders)ThingModifyCommandMappingStrategies.dittoHeadersFrom(adaptable));
    }

    @Nullable
    private static JsonObject initialPolicyForCreateThingFrom(Adaptable adaptable) {
        return adaptable.getPayload().getValue().map(JsonValue::asObject).flatMap(o -> o.getValue(CreateThing.JSON_INLINE_POLICY).map(JsonValue::asObject)).orElse(null);
    }

    @Nullable
    private static String policyIdOrPlaceholderForCreateThingFrom(Adaptable adaptable) {
        return adaptable.getPayload().getValue().map(JsonValue::asObject).flatMap(o -> o.getValue(CreateThing.JSON_COPY_POLICY_FROM)).orElse(null);
    }

    @Nullable
    private static JsonObject initialPolicyForModifyThingFrom(Adaptable adaptable) {
        return adaptable.getPayload().getValue().map(JsonValue::asObject).flatMap(o -> o.getValue(ModifyThing.JSON_INLINE_POLICY).map(JsonValue::asObject)).orElse(null);
    }

    @Nullable
    private static String policyIdOrPlaceholderForModifyThingFrom(Adaptable adaptable) {
        return adaptable.getPayload().getValue().map(JsonValue::asObject).flatMap(o -> o.getValue(ModifyThing.JSON_COPY_POLICY_FROM)).orElse(null);
    }
}

