/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.time.Instant;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.entity.metadata.Metadata;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.json.JsonMissingFieldException;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.Payload;
import org.eclipse.ditto.protocol.mappingstrategies.AbstractThingMappingStrategies;
import org.eclipse.ditto.things.model.ThingId;
import org.eclipse.ditto.things.model.signals.events.ThingMerged;

final class ThingMergedEventMappingStrategies
extends AbstractThingMappingStrategies<ThingMerged> {
    private static final ThingMergedEventMappingStrategies INSTANCE = new ThingMergedEventMappingStrategies();

    private ThingMergedEventMappingStrategies() {
        super(new HashMap());
    }

    static ThingMergedEventMappingStrategies getInstance() {
        return INSTANCE;
    }

    @Override
    public JsonifiableMapper<ThingMerged> find(String type) {
        return ThingMergedEventMappingStrategies::thingMerged;
    }

    private static ThingMerged thingMerged(Adaptable adaptable) {
        return ThingMerged.of((ThingId)ThingMergedEventMappingStrategies.thingIdFrom(adaptable), (JsonPointer)JsonPointer.of((CharSequence)adaptable.getPayload().getPath().toString()), (JsonValue)adaptable.getPayload().getValue().orElse(null), (long)ThingMergedEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingMergedEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingMergedEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingMergedEventMappingStrategies.metadataFrom(adaptable));
    }

    private static long revisionFrom(Adaptable adaptable) {
        return adaptable.getPayload().getRevision().orElseThrow(() -> (JsonMissingFieldException)JsonMissingFieldException.newBuilder().fieldName((CharSequence)Payload.JsonFields.REVISION.getPointer().toString()).build());
    }

    @Nullable
    private static Instant timestampFrom(Adaptable adaptable) {
        return adaptable.getPayload().getTimestamp().orElse(null);
    }

    @Nullable
    private static Metadata metadataFrom(Adaptable adaptable) {
        return adaptable.getPayload().getMetadata().orElse(null);
    }
}

