/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.Payload;
import org.eclipse.ditto.protocol.mappingstrategies.AdaptableToSignalMapper;
import org.eclipse.ditto.protocol.mappingstrategies.MappingStrategies;
import org.eclipse.ditto.things.model.ThingId;
import org.eclipse.ditto.things.model.signals.commands.modify.MergeThingResponse;

final class ThingMergeCommandResponseMappingStrategies
implements MappingStrategies<MergeThingResponse> {
    private static final ThingMergeCommandResponseMappingStrategies INSTANCE = new ThingMergeCommandResponseMappingStrategies();
    private final Map<String, JsonifiableMapper<MergeThingResponse>> mappingStrategies = ThingMergeCommandResponseMappingStrategies.initMappingStrategies();

    private ThingMergeCommandResponseMappingStrategies() {
    }

    private static Map<String, JsonifiableMapper<MergeThingResponse>> initMappingStrategies() {
        AdaptableToSignalMapper<MergeThingResponse> mapper = AdaptableToSignalMapper.of("things.responses:mergeThing", context -> {
            Adaptable adaptable = context.getAdaptable();
            Payload payload = adaptable.getPayload();
            return MergeThingResponse.newInstance((ThingId)context.getThingId(), (JsonPointer)JsonPointer.of((CharSequence)String.valueOf(payload.getPath())), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders());
        });
        return Collections.singletonMap(mapper.getSignalType(), mapper);
    }

    static ThingMergeCommandResponseMappingStrategies getInstance() {
        return INSTANCE;
    }

    @Override
    @Nullable
    public JsonifiableMapper<MergeThingResponse> find(String type) {
        return this.mappingStrategies.get("things.responses:mergeThing");
    }
}

