/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.exceptions.UnsupportedMediaTypeException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.headers.contenttype.ContentType;
import org.eclipse.ditto.base.model.json.JsonSchemaVersion;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.policies.model.PolicyId;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.mappingstrategies.AbstractThingMappingStrategies;
import org.eclipse.ditto.things.model.Attributes;
import org.eclipse.ditto.things.model.Feature;
import org.eclipse.ditto.things.model.FeatureDefinition;
import org.eclipse.ditto.things.model.FeatureProperties;
import org.eclipse.ditto.things.model.Features;
import org.eclipse.ditto.things.model.Thing;
import org.eclipse.ditto.things.model.ThingDefinition;
import org.eclipse.ditto.things.model.ThingId;
import org.eclipse.ditto.things.model.ThingsModelFactory;
import org.eclipse.ditto.things.model.signals.commands.exceptions.PolicyIdNotDeletableException;
import org.eclipse.ditto.things.model.signals.commands.exceptions.ThingIdNotDeletableException;
import org.eclipse.ditto.things.model.signals.commands.exceptions.ThingMergeInvalidException;
import org.eclipse.ditto.things.model.signals.commands.modify.MergeThing;

final class ThingMergeCommandMappingStrategies
extends AbstractThingMappingStrategies<MergeThing> {
    private static final ThingMergeCommandMappingStrategies INSTANCE = new ThingMergeCommandMappingStrategies();

    private ThingMergeCommandMappingStrategies() {
        super(ThingMergeCommandMappingStrategies.initMappingStrategies());
    }

    static ThingMergeCommandMappingStrategies getInstance() {
        return INSTANCE;
    }

    private static Map<String, JsonifiableMapper<MergeThing>> initMappingStrategies() {
        HashMap<String, JsonifiableMapper<MergeThing>> mappingStrategies = new HashMap<String, JsonifiableMapper<MergeThing>>();
        mappingStrategies.put("thing", ThingMergeCommandMappingStrategies::mergeThing);
        mappingStrategies.put("policyId", ThingMergeCommandMappingStrategies::mergeThingWithPolicyId);
        mappingStrategies.put("definition", ThingMergeCommandMappingStrategies::mergeThingWithThingDefinition);
        mappingStrategies.put("attributes", ThingMergeCommandMappingStrategies::mergeThingWithAttributes);
        mappingStrategies.put("attribute", ThingMergeCommandMappingStrategies::mergeThingWithAttribute);
        mappingStrategies.put("features", ThingMergeCommandMappingStrategies::mergeThingWithFeatures);
        mappingStrategies.put("feature", ThingMergeCommandMappingStrategies::mergeThingWithFeature);
        mappingStrategies.put("featureDefinition", ThingMergeCommandMappingStrategies::mergeThingWithFeatureDefinition);
        mappingStrategies.put("featureProperties", ThingMergeCommandMappingStrategies::mergeThingWithFeatureProperties);
        mappingStrategies.put("featureProperty", ThingMergeCommandMappingStrategies::mergeThingWithFeatureProperty);
        mappingStrategies.put("featureDesiredProperties", ThingMergeCommandMappingStrategies::mergeThingWithFeatureDesiredProperties);
        mappingStrategies.put("featureDesiredProperty", ThingMergeCommandMappingStrategies::mergeThingWithFeatureDesiredProperty);
        return mappingStrategies;
    }

    private static MergeThing mergeThing(Adaptable adaptable) {
        ThingMergeCommandMappingStrategies.checkContentTypeHeader(adaptable.getDittoHeaders());
        return MergeThing.withThing((ThingId)ThingMergeCommandMappingStrategies.thingIdFrom(adaptable), (Thing)ThingMergeCommandMappingStrategies.thingForMergeFrom(adaptable), (JsonObject)ThingMergeCommandMappingStrategies.initialPolicyForMergeThingFrom(adaptable), (String)ThingMergeCommandMappingStrategies.policyIdOrPlaceholderForMergeThingFrom(adaptable), (DittoHeaders)ThingMergeCommandMappingStrategies.dittoHeadersFrom(adaptable));
    }

    private static MergeThing mergeThingWithPolicyId(Adaptable adaptable) {
        ThingMergeCommandMappingStrategies.checkContentTypeHeader(adaptable.getDittoHeaders());
        return MergeThing.withPolicyId((ThingId)ThingMergeCommandMappingStrategies.thingIdFrom(adaptable), (PolicyId)ThingMergeCommandMappingStrategies.policyIdForMergeFrom(adaptable), (DittoHeaders)ThingMergeCommandMappingStrategies.dittoHeadersFrom(adaptable));
    }

    private static MergeThing mergeThingWithThingDefinition(Adaptable adaptable) {
        ThingMergeCommandMappingStrategies.checkContentTypeHeader(adaptable.getDittoHeaders());
        return MergeThing.withThingDefinition((ThingId)ThingMergeCommandMappingStrategies.thingIdFrom(adaptable), (ThingDefinition)ThingMergeCommandMappingStrategies.thingDefinitionFromForPatch(adaptable), (DittoHeaders)ThingMergeCommandMappingStrategies.dittoHeadersFrom(adaptable));
    }

    private static MergeThing mergeThingWithAttributes(Adaptable adaptable) {
        ThingMergeCommandMappingStrategies.checkContentTypeHeader(adaptable.getDittoHeaders());
        return MergeThing.withAttributes((ThingId)ThingMergeCommandMappingStrategies.thingIdFrom(adaptable), (Attributes)ThingMergeCommandMappingStrategies.attributesForMergeFrom(adaptable), (DittoHeaders)ThingMergeCommandMappingStrategies.dittoHeadersFrom(adaptable));
    }

    private static MergeThing mergeThingWithAttribute(Adaptable adaptable) {
        ThingMergeCommandMappingStrategies.checkContentTypeHeader(adaptable.getDittoHeaders());
        return MergeThing.withAttribute((ThingId)ThingMergeCommandMappingStrategies.thingIdFrom(adaptable), (JsonPointer)ThingMergeCommandMappingStrategies.attributePointerFrom(adaptable), (JsonValue)ThingMergeCommandMappingStrategies.attributeValueFrom(adaptable), (DittoHeaders)ThingMergeCommandMappingStrategies.dittoHeadersFrom(adaptable));
    }

    private static MergeThing mergeThingWithFeatures(Adaptable adaptable) {
        ThingMergeCommandMappingStrategies.checkContentTypeHeader(adaptable.getDittoHeaders());
        return MergeThing.withFeatures((ThingId)ThingMergeCommandMappingStrategies.thingIdFrom(adaptable), (Features)ThingMergeCommandMappingStrategies.featuresFrom(adaptable), (DittoHeaders)ThingMergeCommandMappingStrategies.dittoHeadersFrom(adaptable));
    }

    private static MergeThing mergeThingWithFeature(Adaptable adaptable) {
        ThingMergeCommandMappingStrategies.checkContentTypeHeader(adaptable.getDittoHeaders());
        return MergeThing.withFeature((ThingId)ThingMergeCommandMappingStrategies.thingIdFrom(adaptable), (Feature)ThingMergeCommandMappingStrategies.featureFrom(adaptable), (DittoHeaders)ThingMergeCommandMappingStrategies.dittoHeadersFrom(adaptable));
    }

    private static MergeThing mergeThingWithFeatureDefinition(Adaptable adaptable) {
        ThingMergeCommandMappingStrategies.checkContentTypeHeader(adaptable.getDittoHeaders());
        return MergeThing.withFeatureDefinition((ThingId)ThingMergeCommandMappingStrategies.thingIdFrom(adaptable), (String)ThingMergeCommandMappingStrategies.featureIdFrom(adaptable), (FeatureDefinition)ThingMergeCommandMappingStrategies.featureDefinitionFrom(adaptable), (DittoHeaders)ThingMergeCommandMappingStrategies.dittoHeadersFrom(adaptable));
    }

    private static MergeThing mergeThingWithFeatureProperties(Adaptable adaptable) {
        ThingMergeCommandMappingStrategies.checkContentTypeHeader(adaptable.getDittoHeaders());
        return MergeThing.withFeatureProperties((ThingId)ThingMergeCommandMappingStrategies.thingIdFrom(adaptable), (String)ThingMergeCommandMappingStrategies.featureIdFrom(adaptable), (FeatureProperties)ThingMergeCommandMappingStrategies.featurePropertiesFrom(adaptable), (DittoHeaders)ThingMergeCommandMappingStrategies.dittoHeadersFrom(adaptable));
    }

    private static MergeThing mergeThingWithFeatureProperty(Adaptable adaptable) {
        ThingMergeCommandMappingStrategies.checkContentTypeHeader(adaptable.getDittoHeaders());
        return MergeThing.withFeatureProperty((ThingId)ThingMergeCommandMappingStrategies.thingIdFrom(adaptable), (String)ThingMergeCommandMappingStrategies.featureIdFrom(adaptable), (JsonPointer)ThingMergeCommandMappingStrategies.featurePropertyPointerFrom(adaptable), (JsonValue)ThingMergeCommandMappingStrategies.featurePropertyValueFrom(adaptable), (DittoHeaders)ThingMergeCommandMappingStrategies.dittoHeadersFrom(adaptable));
    }

    private static MergeThing mergeThingWithFeatureDesiredProperties(Adaptable adaptable) {
        ThingMergeCommandMappingStrategies.checkContentTypeHeader(adaptable.getDittoHeaders());
        return MergeThing.withFeatureDesiredProperties((ThingId)ThingMergeCommandMappingStrategies.thingIdFrom(adaptable), (String)ThingMergeCommandMappingStrategies.featureIdFrom(adaptable), (FeatureProperties)ThingMergeCommandMappingStrategies.featurePropertiesFrom(adaptable), (DittoHeaders)ThingMergeCommandMappingStrategies.dittoHeadersFrom(adaptable));
    }

    private static MergeThing mergeThingWithFeatureDesiredProperty(Adaptable adaptable) {
        ThingMergeCommandMappingStrategies.checkContentTypeHeader(adaptable.getDittoHeaders());
        return MergeThing.withFeatureDesiredProperty((ThingId)ThingMergeCommandMappingStrategies.thingIdFrom(adaptable), (String)ThingMergeCommandMappingStrategies.featureIdFrom(adaptable), (JsonPointer)ThingMergeCommandMappingStrategies.featurePropertyPointerFrom(adaptable), (JsonValue)ThingMergeCommandMappingStrategies.featurePropertyValueFrom(adaptable), (DittoHeaders)ThingMergeCommandMappingStrategies.dittoHeadersFrom(adaptable));
    }

    protected static PolicyId policyIdForMergeFrom(Adaptable adaptable) {
        if (ThingMergeCommandMappingStrategies.payloadValueIsNull(adaptable)) {
            throw (PolicyIdNotDeletableException)PolicyIdNotDeletableException.newBuilder().build();
        }
        return ThingMergeCommandMappingStrategies.policyIdFrom(adaptable);
    }

    protected static ThingDefinition thingDefinitionFromForPatch(Adaptable adaptable) {
        if (ThingMergeCommandMappingStrategies.payloadValueIsNull(adaptable)) {
            return ThingsModelFactory.nullDefinition();
        }
        return ThingMergeCommandMappingStrategies.thingDefinitionFrom(adaptable);
    }

    protected static Thing thingForMergeFrom(Adaptable adaptable) {
        if (ThingMergeCommandMappingStrategies.payloadValueIsNull(adaptable)) {
            if (adaptable.getDittoHeaders().getSchemaVersion().filter(arg_0 -> JsonSchemaVersion.V_2.equals(arg_0)).isPresent()) {
                throw ThingMergeInvalidException.fromMessage((String)"The provided json value can not be applied at this resource", (DittoHeaders)adaptable.getDittoHeaders());
            }
        }
        if (ThingMergeCommandMappingStrategies.fieldIsNull(adaptable, Thing.JsonFields.ID.getPointer())) {
            throw (ThingIdNotDeletableException)ThingIdNotDeletableException.newBuilder().build();
        }
        if (ThingMergeCommandMappingStrategies.fieldIsNull(adaptable, Thing.JsonFields.POLICY_ID.getPointer())) {
            throw (PolicyIdNotDeletableException)PolicyIdNotDeletableException.newBuilder().build();
        }
        return ThingMergeCommandMappingStrategies.thingFrom(adaptable);
    }

    protected static Attributes attributesForMergeFrom(Adaptable adaptable) {
        if (ThingMergeCommandMappingStrategies.fieldIsNull(adaptable, Thing.JsonFields.ATTRIBUTES.getPointer())) {
            return ThingsModelFactory.nullAttributes();
        }
        return ThingMergeCommandMappingStrategies.attributesFrom(adaptable);
    }

    private static boolean fieldIsNull(Adaptable adaptable, JsonPointer pointer) {
        return adaptable.getPayload().getValue().filter(JsonValue::isObject).map(JsonValue::asObject).flatMap(o -> o.getValue((CharSequence)pointer)).map(JsonValue::isNull).orElse(false);
    }

    private static boolean payloadValueIsNull(Adaptable adaptable) {
        return adaptable.getPayload().getValue().map(JsonValue::isNull).orElse(false);
    }

    private static void checkContentTypeHeader(DittoHeaders dittoHeaders) {
        Optional contentType = dittoHeaders.getContentType();
        if (contentType.isPresent()) {
            String requestsMediaType = (String)contentType.get();
            if (!contentType.map(ContentType::of).filter(ContentType::isJsonMergePatch).isPresent()) {
                throw (UnsupportedMediaTypeException)UnsupportedMediaTypeException.builderForMergePatchJsonMediaType((String)requestsMediaType, (String)ContentType.APPLICATION_MERGE_PATCH_JSON.getValue()).dittoHeaders(dittoHeaders).build();
            }
        } else {
            throw (UnsupportedMediaTypeException)UnsupportedMediaTypeException.builderForEmptyContentTypeHeader((String)ContentType.APPLICATION_MERGE_PATCH_JSON.getValue()).dittoHeaders(dittoHeaders).build();
        }
    }

    @Nullable
    private static JsonObject initialPolicyForMergeThingFrom(Adaptable adaptable) {
        return adaptable.getPayload().getValue().filter(JsonValue::isObject).map(JsonValue::asObject).flatMap(MergeThing::initialPolicyForMergeThingFrom).orElse(null);
    }

    @Nullable
    private static String policyIdOrPlaceholderForMergeThingFrom(Adaptable adaptable) {
        return adaptable.getPayload().getValue().filter(JsonValue::isObject).map(JsonValue::asObject).flatMap(MergeThing::policyIdOrPlaceholderForMergeThingFrom).orElse(null);
    }
}

