/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.entity.metadata.Metadata;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.json.JsonMissingFieldException;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.policies.model.PolicyId;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.Payload;
import org.eclipse.ditto.protocol.mappingstrategies.AbstractThingMappingStrategies;
import org.eclipse.ditto.things.model.Attributes;
import org.eclipse.ditto.things.model.Feature;
import org.eclipse.ditto.things.model.FeatureDefinition;
import org.eclipse.ditto.things.model.FeatureProperties;
import org.eclipse.ditto.things.model.Features;
import org.eclipse.ditto.things.model.Thing;
import org.eclipse.ditto.things.model.ThingDefinition;
import org.eclipse.ditto.things.model.ThingId;
import org.eclipse.ditto.things.model.signals.events.AttributeCreated;
import org.eclipse.ditto.things.model.signals.events.AttributeDeleted;
import org.eclipse.ditto.things.model.signals.events.AttributeModified;
import org.eclipse.ditto.things.model.signals.events.AttributesCreated;
import org.eclipse.ditto.things.model.signals.events.AttributesDeleted;
import org.eclipse.ditto.things.model.signals.events.AttributesModified;
import org.eclipse.ditto.things.model.signals.events.FeatureCreated;
import org.eclipse.ditto.things.model.signals.events.FeatureDefinitionCreated;
import org.eclipse.ditto.things.model.signals.events.FeatureDefinitionDeleted;
import org.eclipse.ditto.things.model.signals.events.FeatureDefinitionModified;
import org.eclipse.ditto.things.model.signals.events.FeatureDeleted;
import org.eclipse.ditto.things.model.signals.events.FeatureDesiredPropertiesCreated;
import org.eclipse.ditto.things.model.signals.events.FeatureDesiredPropertiesDeleted;
import org.eclipse.ditto.things.model.signals.events.FeatureDesiredPropertiesModified;
import org.eclipse.ditto.things.model.signals.events.FeatureDesiredPropertyCreated;
import org.eclipse.ditto.things.model.signals.events.FeatureDesiredPropertyDeleted;
import org.eclipse.ditto.things.model.signals.events.FeatureDesiredPropertyModified;
import org.eclipse.ditto.things.model.signals.events.FeatureModified;
import org.eclipse.ditto.things.model.signals.events.FeaturePropertiesCreated;
import org.eclipse.ditto.things.model.signals.events.FeaturePropertiesDeleted;
import org.eclipse.ditto.things.model.signals.events.FeaturePropertiesModified;
import org.eclipse.ditto.things.model.signals.events.FeaturePropertyCreated;
import org.eclipse.ditto.things.model.signals.events.FeaturePropertyDeleted;
import org.eclipse.ditto.things.model.signals.events.FeaturePropertyModified;
import org.eclipse.ditto.things.model.signals.events.FeaturesCreated;
import org.eclipse.ditto.things.model.signals.events.FeaturesDeleted;
import org.eclipse.ditto.things.model.signals.events.FeaturesModified;
import org.eclipse.ditto.things.model.signals.events.PolicyIdModified;
import org.eclipse.ditto.things.model.signals.events.ThingCreated;
import org.eclipse.ditto.things.model.signals.events.ThingDefinitionCreated;
import org.eclipse.ditto.things.model.signals.events.ThingDefinitionDeleted;
import org.eclipse.ditto.things.model.signals.events.ThingDefinitionModified;
import org.eclipse.ditto.things.model.signals.events.ThingDeleted;
import org.eclipse.ditto.things.model.signals.events.ThingEvent;
import org.eclipse.ditto.things.model.signals.events.ThingModified;

final class ThingEventMappingStrategies
extends AbstractThingMappingStrategies<ThingEvent<?>> {
    private static final ThingEventMappingStrategies INSTANCE = new ThingEventMappingStrategies();

    private ThingEventMappingStrategies() {
        super(ThingEventMappingStrategies.initMappingStrategies());
    }

    static ThingEventMappingStrategies getInstance() {
        return INSTANCE;
    }

    private static Map<String, JsonifiableMapper<ThingEvent<?>>> initMappingStrategies() {
        HashMap mappingStrategies = new HashMap();
        ThingEventMappingStrategies.addTopLevelEvents(mappingStrategies);
        ThingEventMappingStrategies.addAttributeEvents(mappingStrategies);
        ThingEventMappingStrategies.addDefinitionEvents(mappingStrategies);
        ThingEventMappingStrategies.addFeatureEvents(mappingStrategies);
        ThingEventMappingStrategies.addFeatureDefinitionEvents(mappingStrategies);
        ThingEventMappingStrategies.addFeaturePropertyEvents(mappingStrategies);
        ThingEventMappingStrategies.addFeatureDesiredPropertyEvents(mappingStrategies);
        ThingEventMappingStrategies.addPolicyIdEvents(mappingStrategies);
        return mappingStrategies;
    }

    private static void addTopLevelEvents(Map<String, JsonifiableMapper<ThingEvent<?>>> mappingStrategies) {
        mappingStrategies.put("things.events:thingCreated", adaptable -> ThingCreated.of((Thing)ThingEventMappingStrategies.thingFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("things.events:thingModified", adaptable -> ThingModified.of((Thing)ThingEventMappingStrategies.thingFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("things.events:thingDeleted", adaptable -> ThingDeleted.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
    }

    private static void addPolicyIdEvents(Map<String, JsonifiableMapper<ThingEvent<?>>> mappingStrategies) {
        mappingStrategies.put("things.events:policyIdModified", adaptable -> PolicyIdModified.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (PolicyId)ThingEventMappingStrategies.policyIdFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
    }

    private static void addFeaturePropertyEvents(Map<String, JsonifiableMapper<ThingEvent<?>>> mappingStrategies) {
        mappingStrategies.put("things.events:featurePropertiesCreated", adaptable -> FeaturePropertiesCreated.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (String)ThingEventMappingStrategies.featureIdFrom(adaptable), (FeatureProperties)ThingEventMappingStrategies.featurePropertiesFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("things.events:featurePropertiesModified", adaptable -> FeaturePropertiesModified.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (String)ThingEventMappingStrategies.featureIdFrom(adaptable), (FeatureProperties)ThingEventMappingStrategies.featurePropertiesFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("things.events:featurePropertiesDeleted", adaptable -> FeaturePropertiesDeleted.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (String)ThingEventMappingStrategies.featureIdFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("things.events:featurePropertyCreated", adaptable -> FeaturePropertyCreated.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (String)ThingEventMappingStrategies.featureIdFrom(adaptable), (JsonPointer)ThingEventMappingStrategies.featurePropertyPointerFrom(adaptable), (JsonValue)ThingEventMappingStrategies.featurePropertyValueFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("things.events:featurePropertyModified", adaptable -> FeaturePropertyModified.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (String)ThingEventMappingStrategies.featureIdFrom(adaptable), (JsonPointer)ThingEventMappingStrategies.featurePropertyPointerFrom(adaptable), (JsonValue)ThingEventMappingStrategies.featurePropertyValueFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("things.events:featurePropertyDeleted", adaptable -> FeaturePropertyDeleted.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (String)ThingEventMappingStrategies.featureIdFrom(adaptable), (JsonPointer)ThingEventMappingStrategies.featurePropertyPointerFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
    }

    private static void addFeatureDesiredPropertyEvents(Map<String, JsonifiableMapper<ThingEvent<?>>> mappingStrategies) {
        mappingStrategies.put("things.events:featureDesiredPropertiesCreated", adaptable -> FeatureDesiredPropertiesCreated.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (CharSequence)ThingEventMappingStrategies.featureIdFrom(adaptable), (FeatureProperties)ThingEventMappingStrategies.featurePropertiesFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("things.events:featureDesiredPropertiesModified", adaptable -> FeatureDesiredPropertiesModified.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (CharSequence)ThingEventMappingStrategies.featureIdFrom(adaptable), (FeatureProperties)ThingEventMappingStrategies.featurePropertiesFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("things.events:featureDesiredPropertiesDeleted", adaptable -> FeatureDesiredPropertiesDeleted.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (CharSequence)ThingEventMappingStrategies.featureIdFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("things.events:featureDesiredPropertyCreated", adaptable -> FeatureDesiredPropertyCreated.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (CharSequence)ThingEventMappingStrategies.featureIdFrom(adaptable), (JsonPointer)ThingEventMappingStrategies.featurePropertyPointerFrom(adaptable), (JsonValue)ThingEventMappingStrategies.featurePropertyValueFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("things.events:featureDesiredPropertyModified", adaptable -> FeatureDesiredPropertyModified.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (String)ThingEventMappingStrategies.featureIdFrom(adaptable), (JsonPointer)ThingEventMappingStrategies.featurePropertyPointerFrom(adaptable), (JsonValue)ThingEventMappingStrategies.featurePropertyValueFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("things.events:featureDesiredPropertyDeleted", adaptable -> FeatureDesiredPropertyDeleted.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (CharSequence)ThingEventMappingStrategies.featureIdFrom(adaptable), (JsonPointer)ThingEventMappingStrategies.featurePropertyPointerFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
    }

    private static void addFeatureDefinitionEvents(Map<String, JsonifiableMapper<ThingEvent<?>>> mappingStrategies) {
        mappingStrategies.put("things.events:featureDefinitionCreated", adaptable -> FeatureDefinitionCreated.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (String)ThingEventMappingStrategies.featureIdFrom(adaptable), (FeatureDefinition)ThingEventMappingStrategies.featureDefinitionFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("things.events:featureDefinitionModified", adaptable -> FeatureDefinitionModified.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (String)ThingEventMappingStrategies.featureIdFrom(adaptable), (FeatureDefinition)ThingEventMappingStrategies.featureDefinitionFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("things.events:featureDefinitionDeleted", adaptable -> FeatureDefinitionDeleted.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (String)ThingEventMappingStrategies.featureIdFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
    }

    private static void addFeatureEvents(Map<String, JsonifiableMapper<ThingEvent<?>>> mappingStrategies) {
        mappingStrategies.put("things.events:featuresCreated", adaptable -> FeaturesCreated.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (Features)ThingEventMappingStrategies.featuresFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("things.events:featuresModified", adaptable -> FeaturesModified.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (Features)ThingEventMappingStrategies.featuresFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("things.events:featuresDeleted", adaptable -> FeaturesDeleted.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("things.events:featureCreated", adaptable -> FeatureCreated.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (Feature)ThingEventMappingStrategies.featureFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("things.events:featureModified", adaptable -> FeatureModified.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (Feature)ThingEventMappingStrategies.featureFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("things.events:featureDeleted", adaptable -> FeatureDeleted.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (String)ThingEventMappingStrategies.featureIdFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
    }

    private static void addDefinitionEvents(Map<String, JsonifiableMapper<ThingEvent<?>>> mappingStrategies) {
        mappingStrategies.put("things.events:definitionCreated", adaptable -> ThingDefinitionCreated.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (ThingDefinition)ThingEventMappingStrategies.thingDefinitionFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("things.events:definitionModified", adaptable -> ThingDefinitionModified.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (ThingDefinition)ThingEventMappingStrategies.thingDefinitionFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("things.events:definitionDeleted", adaptable -> ThingDefinitionDeleted.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
    }

    private static void addAttributeEvents(Map<String, JsonifiableMapper<ThingEvent<?>>> mappingStrategies) {
        mappingStrategies.put("things.events:attributesCreated", adaptable -> AttributesCreated.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (Attributes)ThingEventMappingStrategies.attributesFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("things.events:attributesModified", adaptable -> AttributesModified.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (Attributes)ThingEventMappingStrategies.attributesFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("things.events:attributesDeleted", adaptable -> AttributesDeleted.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("things.events:attributeCreated", adaptable -> AttributeCreated.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (JsonPointer)ThingEventMappingStrategies.attributePointerFrom(adaptable), (JsonValue)ThingEventMappingStrategies.attributeValueFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("things.events:attributeModified", adaptable -> AttributeModified.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (JsonPointer)ThingEventMappingStrategies.attributePointerFrom(adaptable), (JsonValue)ThingEventMappingStrategies.attributeValueFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("things.events:attributeDeleted", adaptable -> AttributeDeleted.of((ThingId)ThingEventMappingStrategies.thingIdFrom(adaptable), (JsonPointer)ThingEventMappingStrategies.attributePointerFrom(adaptable), (long)ThingEventMappingStrategies.revisionFrom(adaptable), (Instant)ThingEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)ThingEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)ThingEventMappingStrategies.metadataFrom(adaptable)));
    }

    private static long revisionFrom(Adaptable adaptable) {
        return adaptable.getPayload().getRevision().orElseThrow(() -> (JsonMissingFieldException)JsonMissingFieldException.newBuilder().fieldName((CharSequence)Payload.JsonFields.REVISION.getPointer().toString()).build());
    }

    @Nullable
    private static Instant timestampFrom(Adaptable adaptable) {
        return adaptable.getPayload().getTimestamp().orElse(null);
    }

    @Nullable
    private static Metadata metadataFrom(Adaptable adaptable) {
        return adaptable.getPayload().getMetadata().orElse(null);
    }
}

