/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.signals.ErrorRegistry;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.adapter.AbstractErrorResponseAdapter;
import org.eclipse.ditto.protocol.mappingstrategies.AbstractSearchMappingStrategies;
import org.eclipse.ditto.thingsearch.model.signals.events.SubscriptionComplete;
import org.eclipse.ditto.thingsearch.model.signals.events.SubscriptionCreated;
import org.eclipse.ditto.thingsearch.model.signals.events.SubscriptionEvent;
import org.eclipse.ditto.thingsearch.model.signals.events.SubscriptionFailed;
import org.eclipse.ditto.thingsearch.model.signals.events.SubscriptionHasNextPage;

final class SubscriptionEventMappingStrategies
extends AbstractSearchMappingStrategies<SubscriptionEvent<?>> {
    private SubscriptionEventMappingStrategies(ErrorRegistry<?> errorRegistry) {
        super(SubscriptionEventMappingStrategies.initMappingStrategies(errorRegistry));
    }

    static SubscriptionEventMappingStrategies getInstance(ErrorRegistry<?> errorRegistry) {
        return new SubscriptionEventMappingStrategies(errorRegistry);
    }

    private static Map<String, JsonifiableMapper<SubscriptionEvent<?>>> initMappingStrategies(ErrorRegistry<?> errorRegistry) {
        HashMap mappingStrategies = new HashMap();
        mappingStrategies.put("thing-search.subscription.events:created", adaptable -> SubscriptionCreated.of((String)Objects.requireNonNull(SubscriptionEventMappingStrategies.subscriptionIdFrom(adaptable)), (DittoHeaders)SubscriptionEventMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("thing-search.subscription.events:complete", adaptable -> SubscriptionComplete.of((String)Objects.requireNonNull(SubscriptionEventMappingStrategies.subscriptionIdFrom(adaptable)), (DittoHeaders)SubscriptionEventMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("thing-search.subscription.events:failed", adaptable -> SubscriptionFailed.of((String)Objects.requireNonNull(SubscriptionEventMappingStrategies.subscriptionIdFrom(adaptable)), (DittoRuntimeException)SubscriptionEventMappingStrategies.errorFrom(adaptable, errorRegistry), (DittoHeaders)SubscriptionEventMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("thing-search.subscription.events:next", adaptable -> SubscriptionHasNextPage.of((String)Objects.requireNonNull(SubscriptionEventMappingStrategies.subscriptionIdFrom(adaptable)), (JsonArray)SubscriptionEventMappingStrategies.itemsFrom(adaptable), (DittoHeaders)SubscriptionEventMappingStrategies.dittoHeadersFrom(adaptable)));
        return mappingStrategies;
    }

    private static JsonArray itemsFrom(Adaptable adaptable) {
        return SubscriptionEventMappingStrategies.getFromValue(adaptable, SubscriptionHasNextPage.JsonFields.ITEMS).orElseGet(JsonArray::empty);
    }

    private static DittoRuntimeException errorFrom(Adaptable adaptable, ErrorRegistry<?> errorRegistry) {
        return SubscriptionEventMappingStrategies.getFromValue(adaptable, SubscriptionFailed.JsonFields.ERROR).map(error -> AbstractErrorResponseAdapter.parseWithErrorRegistry(error, DittoHeaders.empty(), errorRegistry)).orElseThrow(() -> (JsonParseException)JsonParseException.newBuilder().build());
    }
}

