/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.ditto.base.model.entity.id.EntityId;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.signals.ErrorRegistry;
import org.eclipse.ditto.base.model.signals.events.streaming.StreamingSubscriptionComplete;
import org.eclipse.ditto.base.model.signals.events.streaming.StreamingSubscriptionCreated;
import org.eclipse.ditto.base.model.signals.events.streaming.StreamingSubscriptionEvent;
import org.eclipse.ditto.base.model.signals.events.streaming.StreamingSubscriptionFailed;
import org.eclipse.ditto.base.model.signals.events.streaming.StreamingSubscriptionHasNext;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.adapter.AbstractErrorResponseAdapter;
import org.eclipse.ditto.protocol.mappingstrategies.AbstractStreamingSubscriptionMappingStrategies;

final class StreamingSubscriptionEventMappingStrategies
extends AbstractStreamingSubscriptionMappingStrategies<StreamingSubscriptionEvent<?>> {
    private StreamingSubscriptionEventMappingStrategies(ErrorRegistry<?> errorRegistry) {
        super(StreamingSubscriptionEventMappingStrategies.initMappingStrategies(errorRegistry));
    }

    static StreamingSubscriptionEventMappingStrategies getInstance(ErrorRegistry<?> errorRegistry) {
        return new StreamingSubscriptionEventMappingStrategies(errorRegistry);
    }

    private static Map<String, JsonifiableMapper<StreamingSubscriptionEvent<?>>> initMappingStrategies(ErrorRegistry<?> errorRegistry) {
        HashMap mappingStrategies = new HashMap();
        mappingStrategies.put("streaming.subscription.events:created", adaptable -> StreamingSubscriptionCreated.of((String)Objects.requireNonNull(StreamingSubscriptionEventMappingStrategies.subscriptionIdFrom(adaptable)), (EntityId)StreamingSubscriptionEventMappingStrategies.entityIdFrom(adaptable), (DittoHeaders)StreamingSubscriptionEventMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("streaming.subscription.events:complete", adaptable -> StreamingSubscriptionComplete.of((String)Objects.requireNonNull(StreamingSubscriptionEventMappingStrategies.subscriptionIdFrom(adaptable)), (EntityId)StreamingSubscriptionEventMappingStrategies.entityIdFrom(adaptable), (DittoHeaders)StreamingSubscriptionEventMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("streaming.subscription.events:failed", adaptable -> StreamingSubscriptionFailed.of((String)Objects.requireNonNull(StreamingSubscriptionEventMappingStrategies.subscriptionIdFrom(adaptable)), (EntityId)StreamingSubscriptionEventMappingStrategies.entityIdFrom(adaptable), (DittoRuntimeException)StreamingSubscriptionEventMappingStrategies.errorFrom(adaptable, errorRegistry), (DittoHeaders)StreamingSubscriptionEventMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("streaming.subscription.events:next", adaptable -> StreamingSubscriptionHasNext.of((String)Objects.requireNonNull(StreamingSubscriptionEventMappingStrategies.subscriptionIdFrom(adaptable)), (EntityId)StreamingSubscriptionEventMappingStrategies.entityIdFrom(adaptable), (JsonValue)StreamingSubscriptionEventMappingStrategies.itemFrom(adaptable), (DittoHeaders)StreamingSubscriptionEventMappingStrategies.dittoHeadersFrom(adaptable)));
        return mappingStrategies;
    }

    private static JsonValue itemFrom(Adaptable adaptable) {
        return StreamingSubscriptionEventMappingStrategies.getFromValue(adaptable, StreamingSubscriptionHasNext.JsonFields.ITEM).orElseGet(JsonValue::nullLiteral);
    }

    private static DittoRuntimeException errorFrom(Adaptable adaptable, ErrorRegistry<?> errorRegistry) {
        return StreamingSubscriptionEventMappingStrategies.getFromValue(adaptable, StreamingSubscriptionFailed.JsonFields.ERROR).map(error -> AbstractErrorResponseAdapter.parseWithErrorRegistry(error, DittoHeaders.empty(), errorRegistry)).orElseThrow(() -> (JsonParseException)JsonParseException.newBuilder().build());
    }
}

