/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.entity.id.EntityId;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.signals.commands.streaming.CancelStreamingSubscription;
import org.eclipse.ditto.base.model.signals.commands.streaming.RequestFromStreamingSubscription;
import org.eclipse.ditto.base.model.signals.commands.streaming.StreamingSubscriptionCommand;
import org.eclipse.ditto.base.model.signals.commands.streaming.SubscribeForPersistedEvents;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.mappingstrategies.AbstractStreamingSubscriptionMappingStrategies;

final class StreamingSubscriptionCommandMappingStrategies
extends AbstractStreamingSubscriptionMappingStrategies<StreamingSubscriptionCommand<?>> {
    private static final StreamingSubscriptionCommandMappingStrategies INSTANCE = new StreamingSubscriptionCommandMappingStrategies();

    private StreamingSubscriptionCommandMappingStrategies() {
        super(StreamingSubscriptionCommandMappingStrategies.initMappingStrategies());
    }

    static StreamingSubscriptionCommandMappingStrategies getInstance() {
        return INSTANCE;
    }

    private static Map<String, JsonifiableMapper<StreamingSubscriptionCommand<?>>> initMappingStrategies() {
        HashMap mappingStrategies = new HashMap();
        mappingStrategies.put("streaming.subscription.commands:subscribeForPersistedEvents", adaptable -> SubscribeForPersistedEvents.of((EntityId)StreamingSubscriptionCommandMappingStrategies.entityIdFrom(adaptable), (JsonPointer)StreamingSubscriptionCommandMappingStrategies.resourcePathFrom(adaptable), (Long)StreamingSubscriptionCommandMappingStrategies.fromHistoricalRevision(adaptable), (Long)StreamingSubscriptionCommandMappingStrategies.toHistoricalRevision(adaptable), (Instant)StreamingSubscriptionCommandMappingStrategies.fromHistoricalTimestamp(adaptable), (Instant)StreamingSubscriptionCommandMappingStrategies.toHistoricalTimestamp(adaptable), (CharSequence)StreamingSubscriptionCommandMappingStrategies.filterFrom(adaptable), (DittoHeaders)StreamingSubscriptionCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("streaming.subscription.commands:cancel", adaptable -> CancelStreamingSubscription.of((EntityId)StreamingSubscriptionCommandMappingStrategies.entityIdFrom(adaptable), (JsonPointer)StreamingSubscriptionCommandMappingStrategies.resourcePathFrom(adaptable), (String)Objects.requireNonNull(StreamingSubscriptionCommandMappingStrategies.subscriptionIdFrom(adaptable)), (DittoHeaders)StreamingSubscriptionCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("streaming.subscription.commands:request", adaptable -> RequestFromStreamingSubscription.of((EntityId)StreamingSubscriptionCommandMappingStrategies.entityIdFrom(adaptable), (JsonPointer)StreamingSubscriptionCommandMappingStrategies.resourcePathFrom(adaptable), (String)Objects.requireNonNull(StreamingSubscriptionCommandMappingStrategies.subscriptionIdFrom(adaptable)), (long)StreamingSubscriptionCommandMappingStrategies.demandFrom(adaptable), (DittoHeaders)StreamingSubscriptionCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        return mappingStrategies;
    }

    @Nullable
    private static Long fromHistoricalRevision(Adaptable adaptable) {
        return StreamingSubscriptionCommandMappingStrategies.getFromValue(adaptable, SubscribeForPersistedEvents.JsonFields.JSON_FROM_HISTORICAL_REVISION).orElse(null);
    }

    @Nullable
    private static Long toHistoricalRevision(Adaptable adaptable) {
        return StreamingSubscriptionCommandMappingStrategies.getFromValue(adaptable, SubscribeForPersistedEvents.JsonFields.JSON_TO_HISTORICAL_REVISION).orElse(null);
    }

    @Nullable
    private static Instant fromHistoricalTimestamp(Adaptable adaptable) {
        return StreamingSubscriptionCommandMappingStrategies.getFromValue(adaptable, SubscribeForPersistedEvents.JsonFields.JSON_FROM_HISTORICAL_TIMESTAMP).map(Instant::parse).orElse(null);
    }

    @Nullable
    private static Instant toHistoricalTimestamp(Adaptable adaptable) {
        return StreamingSubscriptionCommandMappingStrategies.getFromValue(adaptable, SubscribeForPersistedEvents.JsonFields.JSON_TO_HISTORICAL_TIMESTAMP).map(Instant::parse).orElse(null);
    }

    private static long demandFrom(Adaptable adaptable) {
        return StreamingSubscriptionCommandMappingStrategies.getFromValue(adaptable, RequestFromStreamingSubscription.JsonFields.DEMAND).orElse(0L);
    }

    @Nullable
    private static String filterFrom(Adaptable adaptable) {
        return StreamingSubscriptionCommandMappingStrategies.getFromValue(adaptable, SubscribeForPersistedEvents.JsonFields.FILTER).orElse(null);
    }
}

