/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.Payload;
import org.eclipse.ditto.protocol.mappingstrategies.AbstractThingMappingStrategies;
import org.eclipse.ditto.protocol.mappingstrategies.AdaptableToSignalMapper;
import org.eclipse.ditto.protocol.mappingstrategies.IllegalAdaptableException;
import org.eclipse.ditto.protocol.mappingstrategies.MappingContext;
import org.eclipse.ditto.things.model.signals.commands.query.RetrieveThingsResponse;

public final class RetrieveThingsCommandResponseMappingStrategies
extends AbstractThingMappingStrategies<RetrieveThingsResponse> {
    private static final RetrieveThingsCommandResponseMappingStrategies INSTANCE = new RetrieveThingsCommandResponseMappingStrategies();

    private RetrieveThingsCommandResponseMappingStrategies() {
        super(RetrieveThingsCommandResponseMappingStrategies.initMappingStrategies());
    }

    public static RetrieveThingsCommandResponseMappingStrategies getInstance() {
        return INSTANCE;
    }

    private static Map<String, JsonifiableMapper<RetrieveThingsResponse>> initMappingStrategies() {
        AdaptableToSignalMapper<RetrieveThingsResponse> adaptableToSignalMapper = AdaptableToSignalMapper.of("things.responses:retrieveThings", context -> {
            JsonArray thingsJsonArray = RetrieveThingsCommandResponseMappingStrategies.getThingsArrayOrThrow(context);
            return RetrieveThingsResponse.newInstance((JsonArray)thingsJsonArray, (String)thingsJsonArray.toString(), (String)context.getNamespace().orElse(null), (HttpStatus)context.getHttpStatusOrThrow(), (DittoHeaders)context.getDittoHeaders());
        });
        return Collections.singletonMap(adaptableToSignalMapper.getSignalType(), adaptableToSignalMapper);
    }

    private static JsonArray getThingsArrayOrThrow(MappingContext mappingContext) {
        Adaptable adaptable = mappingContext.getAdaptable();
        Payload payload = adaptable.getPayload();
        Optional<JsonValue> payloadValueOptional = payload.getValue();
        if (payloadValueOptional.isPresent()) {
            JsonValue jsonValue = payloadValueOptional.get();
            if (jsonValue.isArray()) {
                return jsonValue.asArray();
            }
            throw IllegalAdaptableException.newInstance(MessageFormat.format("Payload value is not a JSON array of things but <{0}>.", jsonValue), "Please ensure that the payload contains a valid JSON array of things as value.", adaptable);
        }
        throw IllegalAdaptableException.newInstance("Payload does not contain an array of things because it has no value at all.", "Please ensure that the payload contains a valid JSON array of things as value.", adaptable);
    }
}

