/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.policies.model.Label;
import org.eclipse.ditto.policies.model.PolicyEntry;
import org.eclipse.ditto.policies.model.PolicyId;
import org.eclipse.ditto.policies.model.PolicyImport;
import org.eclipse.ditto.policies.model.PolicyImports;
import org.eclipse.ditto.policies.model.Resource;
import org.eclipse.ditto.policies.model.Resources;
import org.eclipse.ditto.policies.model.Subject;
import org.eclipse.ditto.policies.model.Subjects;
import org.eclipse.ditto.policies.model.signals.commands.query.PolicyQueryCommandResponse;
import org.eclipse.ditto.policies.model.signals.commands.query.RetrievePolicyEntriesResponse;
import org.eclipse.ditto.policies.model.signals.commands.query.RetrievePolicyEntryResponse;
import org.eclipse.ditto.policies.model.signals.commands.query.RetrievePolicyImportResponse;
import org.eclipse.ditto.policies.model.signals.commands.query.RetrievePolicyImportsResponse;
import org.eclipse.ditto.policies.model.signals.commands.query.RetrievePolicyResponse;
import org.eclipse.ditto.policies.model.signals.commands.query.RetrieveResourceResponse;
import org.eclipse.ditto.policies.model.signals.commands.query.RetrieveResourcesResponse;
import org.eclipse.ditto.policies.model.signals.commands.query.RetrieveSubjectResponse;
import org.eclipse.ditto.policies.model.signals.commands.query.RetrieveSubjectsResponse;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.mappingstrategies.AbstractPolicyMappingStrategies;

final class PolicyQueryCommandResponseMappingStrategies
extends AbstractPolicyMappingStrategies<PolicyQueryCommandResponse<?>> {
    private static final PolicyQueryCommandResponseMappingStrategies INSTANCE = new PolicyQueryCommandResponseMappingStrategies();

    static PolicyQueryCommandResponseMappingStrategies getInstance() {
        return INSTANCE;
    }

    private PolicyQueryCommandResponseMappingStrategies() {
        super(PolicyQueryCommandResponseMappingStrategies.initMappingStrategies());
    }

    private static Map<String, JsonifiableMapper<PolicyQueryCommandResponse<?>>> initMappingStrategies() {
        HashMap mappingStrategies = new HashMap();
        PolicyQueryCommandResponseMappingStrategies.addTopLevelResponses(mappingStrategies);
        PolicyQueryCommandResponseMappingStrategies.addPolicyEntryResponses(mappingStrategies);
        PolicyQueryCommandResponseMappingStrategies.addPolicyEntryResourceResponses(mappingStrategies);
        PolicyQueryCommandResponseMappingStrategies.addPolicyEntrySubjectResponses(mappingStrategies);
        PolicyQueryCommandResponseMappingStrategies.addPolicyImportResponses(mappingStrategies);
        return mappingStrategies;
    }

    private static void addTopLevelResponses(Map<String, JsonifiableMapper<PolicyQueryCommandResponse<?>>> mappingStrategies) {
        mappingStrategies.put("policies.responses:retrievePolicy", adaptable -> RetrievePolicyResponse.of((PolicyId)PolicyQueryCommandResponseMappingStrategies.policyIdFromTopicPath(adaptable.getTopicPath()), (JsonObject)PolicyQueryCommandResponseMappingStrategies.policyJsonFrom(adaptable), (DittoHeaders)PolicyQueryCommandResponseMappingStrategies.dittoHeadersFrom(adaptable)));
    }

    private static void addPolicyEntryResponses(Map<String, JsonifiableMapper<PolicyQueryCommandResponse<?>>> mappingStrategies) {
        mappingStrategies.put("policies.responses:retrievePolicyEntry", adaptable -> RetrievePolicyEntryResponse.of((PolicyId)PolicyQueryCommandResponseMappingStrategies.policyIdFromTopicPath(adaptable.getTopicPath()), (PolicyEntry)PolicyQueryCommandResponseMappingStrategies.policyEntryFrom(adaptable), (DittoHeaders)PolicyQueryCommandResponseMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("policies.responses:retrievePolicyEntries", adaptable -> RetrievePolicyEntriesResponse.of((PolicyId)PolicyQueryCommandResponseMappingStrategies.policyIdFromTopicPath(adaptable.getTopicPath()), PolicyQueryCommandResponseMappingStrategies.policyEntriesFrom(adaptable), (DittoHeaders)PolicyQueryCommandResponseMappingStrategies.dittoHeadersFrom(adaptable)));
    }

    private static void addPolicyImportResponses(Map<String, JsonifiableMapper<PolicyQueryCommandResponse<?>>> mappingStrategies) {
        mappingStrategies.put("policies.responses:retrievePolicyImport", adaptable -> RetrievePolicyImportResponse.of((PolicyId)PolicyQueryCommandResponseMappingStrategies.policyIdFromTopicPath(adaptable.getTopicPath()), (PolicyImport)PolicyQueryCommandResponseMappingStrategies.policyImportFrom(adaptable), (DittoHeaders)PolicyQueryCommandResponseMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("policies.responses:retrievePolicyImports", adaptable -> RetrievePolicyImportsResponse.of((PolicyId)PolicyQueryCommandResponseMappingStrategies.policyIdFromTopicPath(adaptable.getTopicPath()), (PolicyImports)PolicyQueryCommandResponseMappingStrategies.policyImportsFrom(adaptable), (DittoHeaders)PolicyQueryCommandResponseMappingStrategies.dittoHeadersFrom(adaptable)));
    }

    private static void addPolicyEntryResourceResponses(Map<String, JsonifiableMapper<PolicyQueryCommandResponse<?>>> mappingStrategies) {
        mappingStrategies.put("policies.responses:retrieveResource", adaptable -> RetrieveResourceResponse.of((PolicyId)PolicyQueryCommandResponseMappingStrategies.policyIdFromTopicPath(adaptable.getTopicPath()), (Label)PolicyQueryCommandResponseMappingStrategies.labelFrom(adaptable), (Resource)PolicyQueryCommandResponseMappingStrategies.resourceFrom(adaptable), (DittoHeaders)PolicyQueryCommandResponseMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("policies.responses:retrieveResources", adaptable -> RetrieveResourcesResponse.of((PolicyId)PolicyQueryCommandResponseMappingStrategies.policyIdFromTopicPath(adaptable.getTopicPath()), (Label)PolicyQueryCommandResponseMappingStrategies.labelFrom(adaptable), (Resources)PolicyQueryCommandResponseMappingStrategies.resourcesFrom(adaptable), (DittoHeaders)PolicyQueryCommandResponseMappingStrategies.dittoHeadersFrom(adaptable)));
    }

    private static void addPolicyEntrySubjectResponses(Map<String, JsonifiableMapper<PolicyQueryCommandResponse<?>>> mappingStrategies) {
        mappingStrategies.put("policies.responses:retrieveSubject", adaptable -> RetrieveSubjectResponse.of((PolicyId)PolicyQueryCommandResponseMappingStrategies.policyIdFromTopicPath(adaptable.getTopicPath()), (Label)PolicyQueryCommandResponseMappingStrategies.labelFrom(adaptable), (Subject)PolicyQueryCommandResponseMappingStrategies.subjectFrom(adaptable), (DittoHeaders)PolicyQueryCommandResponseMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("policies.responses:retrieveSubjects", adaptable -> RetrieveSubjectsResponse.of((PolicyId)PolicyQueryCommandResponseMappingStrategies.policyIdFromTopicPath(adaptable.getTopicPath()), (Label)PolicyQueryCommandResponseMappingStrategies.labelFrom(adaptable), (Subjects)PolicyQueryCommandResponseMappingStrategies.subjectsFrom(adaptable), (DittoHeaders)PolicyQueryCommandResponseMappingStrategies.dittoHeadersFrom(adaptable)));
    }
}

