/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.policies.model.Label;
import org.eclipse.ditto.policies.model.PolicyId;
import org.eclipse.ditto.policies.model.ResourceKey;
import org.eclipse.ditto.policies.model.SubjectId;
import org.eclipse.ditto.policies.model.signals.commands.query.PolicyQueryCommand;
import org.eclipse.ditto.policies.model.signals.commands.query.RetrievePolicy;
import org.eclipse.ditto.policies.model.signals.commands.query.RetrievePolicyEntries;
import org.eclipse.ditto.policies.model.signals.commands.query.RetrievePolicyEntry;
import org.eclipse.ditto.policies.model.signals.commands.query.RetrievePolicyImport;
import org.eclipse.ditto.policies.model.signals.commands.query.RetrievePolicyImports;
import org.eclipse.ditto.policies.model.signals.commands.query.RetrieveResource;
import org.eclipse.ditto.policies.model.signals.commands.query.RetrieveResources;
import org.eclipse.ditto.policies.model.signals.commands.query.RetrieveSubject;
import org.eclipse.ditto.policies.model.signals.commands.query.RetrieveSubjects;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.mappingstrategies.AbstractPolicyMappingStrategies;

final class PolicyQueryCommandMappingStrategies
extends AbstractPolicyMappingStrategies<PolicyQueryCommand<?>> {
    private static final PolicyQueryCommandMappingStrategies INSTANCE = new PolicyQueryCommandMappingStrategies();

    static PolicyQueryCommandMappingStrategies getInstance() {
        return INSTANCE;
    }

    private PolicyQueryCommandMappingStrategies() {
        super(PolicyQueryCommandMappingStrategies.initMappingStrategies());
    }

    private static Map<String, JsonifiableMapper<PolicyQueryCommand<?>>> initMappingStrategies() {
        HashMap mappingStrategies = new HashMap();
        mappingStrategies.put("policies.commands:retrievePolicy", adaptable -> RetrievePolicy.of((PolicyId)PolicyQueryCommandMappingStrategies.policyIdFromTopicPath(adaptable.getTopicPath()), (DittoHeaders)PolicyQueryCommandMappingStrategies.dittoHeadersFrom(adaptable), (JsonFieldSelector)PolicyQueryCommandMappingStrategies.selectedFieldsFrom(adaptable)));
        mappingStrategies.put("policies.commands:retrievePolicyEntry", adaptable -> RetrievePolicyEntry.of((PolicyId)PolicyQueryCommandMappingStrategies.policyIdFromTopicPath(adaptable.getTopicPath()), (Label)PolicyQueryCommandMappingStrategies.labelFrom(adaptable), (DittoHeaders)PolicyQueryCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("policies.commands:retrievePolicyEntries", adaptable -> RetrievePolicyEntries.of((PolicyId)PolicyQueryCommandMappingStrategies.policyIdFromTopicPath(adaptable.getTopicPath()), (DittoHeaders)PolicyQueryCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("policies.commands:retrievePolicyImport", adaptable -> RetrievePolicyImport.of((PolicyId)PolicyQueryCommandMappingStrategies.policyIdFromTopicPath(adaptable.getTopicPath()), (PolicyId)PolicyQueryCommandMappingStrategies.importedPolicyIdFrom(adaptable), (DittoHeaders)PolicyQueryCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("policies.commands:retrievePolicyImports", adaptable -> RetrievePolicyImports.of((PolicyId)PolicyQueryCommandMappingStrategies.policyIdFromTopicPath(adaptable.getTopicPath()), (DittoHeaders)PolicyQueryCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("policies.commands:retrieveResource", adaptable -> RetrieveResource.of((PolicyId)PolicyQueryCommandMappingStrategies.policyIdFromTopicPath(adaptable.getTopicPath()), (Label)PolicyQueryCommandMappingStrategies.labelFrom(adaptable), (ResourceKey)PolicyQueryCommandMappingStrategies.entryResourceKeyFromPath(adaptable.getPayload().getPath()), (DittoHeaders)PolicyQueryCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("policies.commands:retrieveResources", adaptable -> RetrieveResources.of((PolicyId)PolicyQueryCommandMappingStrategies.policyIdFromTopicPath(adaptable.getTopicPath()), (Label)PolicyQueryCommandMappingStrategies.labelFrom(adaptable), (DittoHeaders)PolicyQueryCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("policies.commands:retrieveSubject", adaptable -> RetrieveSubject.of((PolicyId)PolicyQueryCommandMappingStrategies.policyIdFromTopicPath(adaptable.getTopicPath()), (Label)PolicyQueryCommandMappingStrategies.labelFrom(adaptable), (SubjectId)PolicyQueryCommandMappingStrategies.entrySubjectIdFromPath(adaptable.getPayload().getPath()), (DittoHeaders)PolicyQueryCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("policies.commands:retrieveSubjects", adaptable -> RetrieveSubjects.of((PolicyId)PolicyQueryCommandMappingStrategies.policyIdFromTopicPath(adaptable.getTopicPath()), (Label)PolicyQueryCommandMappingStrategies.labelFrom(adaptable), (DittoHeaders)PolicyQueryCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        return mappingStrategies;
    }
}

