/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.policies.model.Label;
import org.eclipse.ditto.policies.model.Policy;
import org.eclipse.ditto.policies.model.PolicyEntry;
import org.eclipse.ditto.policies.model.PolicyId;
import org.eclipse.ditto.policies.model.PolicyImport;
import org.eclipse.ditto.policies.model.PolicyImports;
import org.eclipse.ditto.policies.model.Resource;
import org.eclipse.ditto.policies.model.ResourceKey;
import org.eclipse.ditto.policies.model.Subject;
import org.eclipse.ditto.policies.model.SubjectId;
import org.eclipse.ditto.policies.model.signals.commands.modify.CreatePolicyResponse;
import org.eclipse.ditto.policies.model.signals.commands.modify.DeletePolicyEntryResponse;
import org.eclipse.ditto.policies.model.signals.commands.modify.DeletePolicyImportResponse;
import org.eclipse.ditto.policies.model.signals.commands.modify.DeletePolicyResponse;
import org.eclipse.ditto.policies.model.signals.commands.modify.DeleteResourceResponse;
import org.eclipse.ditto.policies.model.signals.commands.modify.DeleteSubjectResponse;
import org.eclipse.ditto.policies.model.signals.commands.modify.ModifyPolicyEntriesResponse;
import org.eclipse.ditto.policies.model.signals.commands.modify.ModifyPolicyEntryResponse;
import org.eclipse.ditto.policies.model.signals.commands.modify.ModifyPolicyImportResponse;
import org.eclipse.ditto.policies.model.signals.commands.modify.ModifyPolicyImportsResponse;
import org.eclipse.ditto.policies.model.signals.commands.modify.ModifyPolicyResponse;
import org.eclipse.ditto.policies.model.signals.commands.modify.ModifyResourceResponse;
import org.eclipse.ditto.policies.model.signals.commands.modify.ModifyResourcesResponse;
import org.eclipse.ditto.policies.model.signals.commands.modify.ModifySubjectResponse;
import org.eclipse.ditto.policies.model.signals.commands.modify.ModifySubjectsResponse;
import org.eclipse.ditto.policies.model.signals.commands.modify.PolicyModifyCommandResponse;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.mappingstrategies.AdaptableToSignalMapper;
import org.eclipse.ditto.protocol.mappingstrategies.MappingStrategies;

final class PolicyModifyCommandResponseMappingStrategies
implements MappingStrategies<PolicyModifyCommandResponse<?>> {
    private static final PolicyModifyCommandResponseMappingStrategies INSTANCE = new PolicyModifyCommandResponseMappingStrategies();
    private final Map<String, JsonifiableMapper<? extends PolicyModifyCommandResponse<?>>> mappingStrategies = Collections.unmodifiableMap(PolicyModifyCommandResponseMappingStrategies.initMappingStrategies());

    private PolicyModifyCommandResponseMappingStrategies() {
    }

    private static Map<String, AdaptableToSignalMapper<? extends PolicyModifyCommandResponse<?>>> initMappingStrategies() {
        Stream.Builder<AdaptableToSignalMapper<PolicyModifyCommandResponse<?>>> streamBuilder = Stream.builder();
        PolicyModifyCommandResponseMappingStrategies.addTopLevelResponses(streamBuilder);
        PolicyModifyCommandResponseMappingStrategies.addPolicyEntryResponses(streamBuilder);
        PolicyModifyCommandResponseMappingStrategies.addPolicyEntryResourceResponses(streamBuilder);
        PolicyModifyCommandResponseMappingStrategies.addPolicyEntrySubjectResponses(streamBuilder);
        PolicyModifyCommandResponseMappingStrategies.addPolicyImportResponses(streamBuilder);
        Stream<AdaptableToSignalMapper<PolicyModifyCommandResponse<?>>> mappers = streamBuilder.build();
        return mappers.collect(Collectors.toMap(AdaptableToSignalMapper::getSignalType, Function.identity()));
    }

    static PolicyModifyCommandResponseMappingStrategies getInstance() {
        return INSTANCE;
    }

    private static void addTopLevelResponses(Consumer<AdaptableToSignalMapper<? extends PolicyModifyCommandResponse<?>>> streamBuilder) {
        streamBuilder.accept(AdaptableToSignalMapper.of("policies.responses:createPolicy", mappingContext -> CreatePolicyResponse.newInstance((PolicyId)mappingContext.getPolicyIdFromTopicPath(), (Policy)mappingContext.getPolicy().orElse(null), (HttpStatus)mappingContext.getHttpStatusOrThrow(), (DittoHeaders)mappingContext.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("policies.responses:modifyPolicy", mappingContext -> ModifyPolicyResponse.newInstance((PolicyId)mappingContext.getPolicyIdFromTopicPath(), (Policy)mappingContext.getPolicy().orElse(null), (HttpStatus)mappingContext.getHttpStatusOrThrow(), (DittoHeaders)mappingContext.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("policies.responses:deletePolicy", mappingContext -> DeletePolicyResponse.newInstance((PolicyId)mappingContext.getPolicyIdFromTopicPath(), (HttpStatus)mappingContext.getHttpStatusOrThrow(), (DittoHeaders)mappingContext.getDittoHeaders())));
    }

    private static void addPolicyEntryResponses(Consumer<AdaptableToSignalMapper<? extends PolicyModifyCommandResponse<?>>> streamBuilder) {
        streamBuilder.accept(AdaptableToSignalMapper.of("policies.responses:modifyPolicyEntry", mappingContext -> ModifyPolicyEntryResponse.newInstance((PolicyId)mappingContext.getPolicyIdFromTopicPath(), (PolicyEntry)mappingContext.getPolicyEntry().orElse(null), (Label)mappingContext.getLabelOrThrow(), (HttpStatus)mappingContext.getHttpStatusOrThrow(), (DittoHeaders)mappingContext.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("policies.responses:deletePolicyEntry", mappingContext -> DeletePolicyEntryResponse.newInstance((PolicyId)mappingContext.getPolicyIdFromTopicPath(), (Label)mappingContext.getLabelOrThrow(), (HttpStatus)mappingContext.getHttpStatusOrThrow(), (DittoHeaders)mappingContext.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("policies.responses:modifyPolicyEntries", mappingContext -> ModifyPolicyEntriesResponse.newInstance((PolicyId)mappingContext.getPolicyIdFromTopicPath(), (HttpStatus)mappingContext.getHttpStatusOrThrow(), (DittoHeaders)mappingContext.getDittoHeaders())));
    }

    private static void addPolicyImportResponses(Consumer<AdaptableToSignalMapper<? extends PolicyModifyCommandResponse<?>>> streamBuilder) {
        streamBuilder.accept(AdaptableToSignalMapper.of("policies.responses:modifyPolicyImports", mappingContext -> ModifyPolicyImportsResponse.newInstance((PolicyId)mappingContext.getPolicyIdFromTopicPath(), (PolicyImports)mappingContext.getPolicyImports().orElse(null), (HttpStatus)mappingContext.getHttpStatusOrThrow(), (DittoHeaders)mappingContext.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("policies.responses:modifyPolicyImport", mappingContext -> ModifyPolicyImportResponse.newInstance((PolicyId)mappingContext.getPolicyIdFromTopicPath(), (PolicyId)mappingContext.getImportedPolicyId(), (PolicyImport)mappingContext.getPolicyImport().orElse(null), (HttpStatus)mappingContext.getHttpStatusOrThrow(), (DittoHeaders)mappingContext.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("policies.responses:deletePolicyImport", mappingContext -> DeletePolicyImportResponse.newInstance((PolicyId)mappingContext.getPolicyIdFromTopicPath(), (PolicyId)mappingContext.getImportedPolicyId(), (HttpStatus)mappingContext.getHttpStatusOrThrow(), (DittoHeaders)mappingContext.getDittoHeaders())));
    }

    private static void addPolicyEntryResourceResponses(Consumer<AdaptableToSignalMapper<? extends PolicyModifyCommandResponse<?>>> streamBuilder) {
        streamBuilder.accept(AdaptableToSignalMapper.of("policies.responses:modifyResource", mappingContext -> ModifyResourceResponse.newInstance((PolicyId)mappingContext.getPolicyIdFromTopicPath(), (Label)mappingContext.getLabelOrThrow(), (ResourceKey)mappingContext.getResourceKeyOrThrow(), (Resource)mappingContext.getResource().orElse(null), (HttpStatus)mappingContext.getHttpStatusOrThrow(), (DittoHeaders)mappingContext.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("policies.responses:modifyResources", mappingContext -> ModifyResourcesResponse.newInstance((PolicyId)mappingContext.getPolicyIdFromTopicPath(), (Label)mappingContext.getLabelOrThrow(), (HttpStatus)mappingContext.getHttpStatusOrThrow(), (DittoHeaders)mappingContext.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("policies.responses:deleteResource", mappingContext -> DeleteResourceResponse.newInstance((PolicyId)mappingContext.getPolicyIdFromTopicPath(), (Label)mappingContext.getLabelOrThrow(), (ResourceKey)mappingContext.getResourceKeyOrThrow(), (HttpStatus)mappingContext.getHttpStatusOrThrow(), (DittoHeaders)mappingContext.getDittoHeaders())));
    }

    private static void addPolicyEntrySubjectResponses(Consumer<AdaptableToSignalMapper<? extends PolicyModifyCommandResponse<?>>> streamBuilder) {
        streamBuilder.accept(AdaptableToSignalMapper.of("policies.responses:modifySubject", mappingContext -> ModifySubjectResponse.newInstance((PolicyId)mappingContext.getPolicyIdFromTopicPath(), (Label)mappingContext.getLabelOrThrow(), (SubjectId)mappingContext.getSubjectIdOrThrow(), (Subject)mappingContext.getSubject().orElse(null), (HttpStatus)mappingContext.getHttpStatusOrThrow(), (DittoHeaders)mappingContext.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("policies.responses:modifySubjects", mappingContext -> ModifySubjectsResponse.newInstance((PolicyId)mappingContext.getPolicyIdFromTopicPath(), (Label)mappingContext.getLabelOrThrow(), (HttpStatus)mappingContext.getHttpStatusOrThrow(), (DittoHeaders)mappingContext.getDittoHeaders())));
        streamBuilder.accept(AdaptableToSignalMapper.of("policies.responses:deleteSubject", mappingContext -> DeleteSubjectResponse.newInstance((PolicyId)mappingContext.getPolicyIdFromTopicPath(), (Label)mappingContext.getLabelOrThrow(), (SubjectId)mappingContext.getSubjectIdOrThrow(), (HttpStatus)mappingContext.getHttpStatusOrThrow(), (DittoHeaders)mappingContext.getDittoHeaders())));
    }

    @Override
    @Nullable
    public JsonifiableMapper<PolicyModifyCommandResponse<?>> find(String type) {
        return this.mappingStrategies.get(type);
    }
}

