/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.entity.metadata.Metadata;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.json.JsonMissingFieldException;
import org.eclipse.ditto.policies.model.Label;
import org.eclipse.ditto.policies.model.Policy;
import org.eclipse.ditto.policies.model.PolicyEntry;
import org.eclipse.ditto.policies.model.PolicyId;
import org.eclipse.ditto.policies.model.Resource;
import org.eclipse.ditto.policies.model.ResourceKey;
import org.eclipse.ditto.policies.model.Resources;
import org.eclipse.ditto.policies.model.Subject;
import org.eclipse.ditto.policies.model.SubjectId;
import org.eclipse.ditto.policies.model.Subjects;
import org.eclipse.ditto.policies.model.signals.events.PolicyCreated;
import org.eclipse.ditto.policies.model.signals.events.PolicyDeleted;
import org.eclipse.ditto.policies.model.signals.events.PolicyEntriesModified;
import org.eclipse.ditto.policies.model.signals.events.PolicyEntryCreated;
import org.eclipse.ditto.policies.model.signals.events.PolicyEntryDeleted;
import org.eclipse.ditto.policies.model.signals.events.PolicyEntryModified;
import org.eclipse.ditto.policies.model.signals.events.PolicyEvent;
import org.eclipse.ditto.policies.model.signals.events.PolicyModified;
import org.eclipse.ditto.policies.model.signals.events.ResourceCreated;
import org.eclipse.ditto.policies.model.signals.events.ResourceDeleted;
import org.eclipse.ditto.policies.model.signals.events.ResourceModified;
import org.eclipse.ditto.policies.model.signals.events.ResourcesModified;
import org.eclipse.ditto.policies.model.signals.events.SubjectCreated;
import org.eclipse.ditto.policies.model.signals.events.SubjectDeleted;
import org.eclipse.ditto.policies.model.signals.events.SubjectModified;
import org.eclipse.ditto.policies.model.signals.events.SubjectsDeletedPartially;
import org.eclipse.ditto.policies.model.signals.events.SubjectsModified;
import org.eclipse.ditto.policies.model.signals.events.SubjectsModifiedPartially;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.Payload;
import org.eclipse.ditto.protocol.mappingstrategies.AbstractPolicyMappingStrategies;

final class PolicyEventMappingStrategies
extends AbstractPolicyMappingStrategies<PolicyEvent<?>> {
    private static final PolicyEventMappingStrategies INSTANCE = new PolicyEventMappingStrategies();

    private PolicyEventMappingStrategies() {
        super(PolicyEventMappingStrategies.initMappingStrategies());
    }

    static PolicyEventMappingStrategies getInstance() {
        return INSTANCE;
    }

    private static Map<String, JsonifiableMapper<PolicyEvent<?>>> initMappingStrategies() {
        HashMap mappingStrategies = new HashMap();
        PolicyEventMappingStrategies.addTopLevelEvents(mappingStrategies);
        PolicyEventMappingStrategies.addPolicyEntriesEvents(mappingStrategies);
        PolicyEventMappingStrategies.addPolicyEntryEvents(mappingStrategies);
        PolicyEventMappingStrategies.addResourcesEvents(mappingStrategies);
        PolicyEventMappingStrategies.addResourceEvents(mappingStrategies);
        PolicyEventMappingStrategies.addSubjectsEvents(mappingStrategies);
        PolicyEventMappingStrategies.addSubjectEvents(mappingStrategies);
        return mappingStrategies;
    }

    private static void addTopLevelEvents(Map<String, JsonifiableMapper<PolicyEvent<?>>> mappingStrategies) {
        mappingStrategies.put("policies.events:policyCreated", adaptable -> PolicyCreated.of((Policy)PolicyEventMappingStrategies.policyFrom(adaptable), (long)PolicyEventMappingStrategies.revisionFrom(adaptable), (Instant)PolicyEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)PolicyEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)PolicyEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("policies.events:policyModified", adaptable -> PolicyModified.of((Policy)PolicyEventMappingStrategies.policyFrom(adaptable), (long)PolicyEventMappingStrategies.revisionFrom(adaptable), (Instant)PolicyEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)PolicyEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)PolicyEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("policies.events:policyDeleted", adaptable -> PolicyDeleted.of((PolicyId)PolicyEventMappingStrategies.policyIdFrom(adaptable), (long)PolicyEventMappingStrategies.revisionFrom(adaptable), (Instant)PolicyEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)PolicyEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)PolicyEventMappingStrategies.metadataFrom(adaptable)));
    }

    private static void addPolicyEntriesEvents(Map<String, JsonifiableMapper<PolicyEvent<?>>> mappingStrategies) {
        mappingStrategies.put("policies.events:policyEntriesModified", adaptable -> PolicyEntriesModified.of((PolicyId)PolicyEventMappingStrategies.policyIdFrom(adaptable), PolicyEventMappingStrategies.policyEntriesFrom(adaptable), (long)PolicyEventMappingStrategies.revisionFrom(adaptable), (Instant)PolicyEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)PolicyEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)PolicyEventMappingStrategies.metadataFrom(adaptable)));
    }

    private static void addPolicyEntryEvents(Map<String, JsonifiableMapper<PolicyEvent<?>>> mappingStrategies) {
        mappingStrategies.put("policies.events:policyEntryCreated", adaptable -> PolicyEntryCreated.of((PolicyId)PolicyEventMappingStrategies.policyIdFrom(adaptable), (PolicyEntry)PolicyEventMappingStrategies.policyEntryFrom(adaptable), (long)PolicyEventMappingStrategies.revisionFrom(adaptable), (Instant)PolicyEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)PolicyEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)PolicyEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("policies.events:policyEntryModified", adaptable -> PolicyEntryModified.of((PolicyId)PolicyEventMappingStrategies.policyIdFrom(adaptable), (PolicyEntry)PolicyEventMappingStrategies.policyEntryFrom(adaptable), (long)PolicyEventMappingStrategies.revisionFrom(adaptable), (Instant)PolicyEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)PolicyEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)PolicyEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("policies.events:policyEntryDeleted", adaptable -> PolicyEntryDeleted.of((PolicyId)PolicyEventMappingStrategies.policyIdFrom(adaptable), (Label)PolicyEventMappingStrategies.labelFrom(adaptable), (long)PolicyEventMappingStrategies.revisionFrom(adaptable), (Instant)PolicyEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)PolicyEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)PolicyEventMappingStrategies.metadataFrom(adaptable)));
    }

    private static void addResourcesEvents(Map<String, JsonifiableMapper<PolicyEvent<?>>> mappingStrategies) {
        mappingStrategies.put("policies.events:resourcesModified", adaptable -> ResourcesModified.of((PolicyId)PolicyEventMappingStrategies.policyIdFrom(adaptable), (Label)PolicyEventMappingStrategies.labelFrom(adaptable), (Resources)PolicyEventMappingStrategies.resourcesFrom(adaptable), (long)PolicyEventMappingStrategies.revisionFrom(adaptable), (Instant)PolicyEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)PolicyEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)PolicyEventMappingStrategies.metadataFrom(adaptable)));
    }

    private static void addResourceEvents(Map<String, JsonifiableMapper<PolicyEvent<?>>> mappingStrategies) {
        mappingStrategies.put("policies.events:resourceCreated", adaptable -> ResourceCreated.of((PolicyId)PolicyEventMappingStrategies.policyIdFrom(adaptable), (Label)PolicyEventMappingStrategies.labelFrom(adaptable), (Resource)PolicyEventMappingStrategies.resourceFrom(adaptable), (long)PolicyEventMappingStrategies.revisionFrom(adaptable), (Instant)PolicyEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)PolicyEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)PolicyEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("policies.events:resourceModified", adaptable -> ResourceModified.of((PolicyId)PolicyEventMappingStrategies.policyIdFrom(adaptable), (Label)PolicyEventMappingStrategies.labelFrom(adaptable), (Resource)PolicyEventMappingStrategies.resourceFrom(adaptable), (long)PolicyEventMappingStrategies.revisionFrom(adaptable), (Instant)PolicyEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)PolicyEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)PolicyEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("policies.events:resourceDeleted", adaptable -> ResourceDeleted.of((PolicyId)PolicyEventMappingStrategies.policyIdFrom(adaptable), (Label)PolicyEventMappingStrategies.labelFrom(adaptable), (ResourceKey)PolicyEventMappingStrategies.entryResourceKeyFromPath(adaptable.getPayload().getPath()), (long)PolicyEventMappingStrategies.revisionFrom(adaptable), (Instant)PolicyEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)PolicyEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)PolicyEventMappingStrategies.metadataFrom(adaptable)));
    }

    private static void addSubjectsEvents(Map<String, JsonifiableMapper<PolicyEvent<?>>> mappingStrategies) {
        mappingStrategies.put("policies.events:subjectsModified", adaptable -> SubjectsModified.of((PolicyId)PolicyEventMappingStrategies.policyIdFrom(adaptable), (Label)PolicyEventMappingStrategies.labelFrom(adaptable), (Subjects)PolicyEventMappingStrategies.subjectsFrom(adaptable), (long)PolicyEventMappingStrategies.revisionFrom(adaptable), (Instant)PolicyEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)PolicyEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)PolicyEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("policies.events:subjectsModifiedPartially", adaptable -> SubjectsModifiedPartially.of((PolicyId)PolicyEventMappingStrategies.policyIdFrom(adaptable), PolicyEventMappingStrategies.activatedSubjectsFrom(adaptable), (long)PolicyEventMappingStrategies.revisionFrom(adaptable), (Instant)PolicyEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)PolicyEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)PolicyEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("policies.events:subjectsDeletedPartially", adaptable -> SubjectsDeletedPartially.of((PolicyId)PolicyEventMappingStrategies.policyIdFrom(adaptable), PolicyEventMappingStrategies.deletedSubjectIdsFrom(adaptable), (long)PolicyEventMappingStrategies.revisionFrom(adaptable), (Instant)PolicyEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)PolicyEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)PolicyEventMappingStrategies.metadataFrom(adaptable)));
    }

    private static void addSubjectEvents(Map<String, JsonifiableMapper<PolicyEvent<?>>> mappingStrategies) {
        mappingStrategies.put("policies.events:subjectCreated", adaptable -> SubjectCreated.of((PolicyId)PolicyEventMappingStrategies.policyIdFrom(adaptable), (Label)PolicyEventMappingStrategies.labelFrom(adaptable), (Subject)PolicyEventMappingStrategies.subjectFrom(adaptable), (long)PolicyEventMappingStrategies.revisionFrom(adaptable), (Instant)PolicyEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)PolicyEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)PolicyEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("policies.events:subjectModified", adaptable -> SubjectModified.of((PolicyId)PolicyEventMappingStrategies.policyIdFrom(adaptable), (Label)PolicyEventMappingStrategies.labelFrom(adaptable), (Subject)PolicyEventMappingStrategies.subjectFrom(adaptable), (long)PolicyEventMappingStrategies.revisionFrom(adaptable), (Instant)PolicyEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)PolicyEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)PolicyEventMappingStrategies.metadataFrom(adaptable)));
        mappingStrategies.put("policies.events:subjectDeleted", adaptable -> SubjectDeleted.of((PolicyId)PolicyEventMappingStrategies.policyIdFrom(adaptable), (Label)PolicyEventMappingStrategies.labelFrom(adaptable), (SubjectId)PolicyEventMappingStrategies.entrySubjectIdFromPath(adaptable.getPayload().getPath()), (long)PolicyEventMappingStrategies.revisionFrom(adaptable), (Instant)PolicyEventMappingStrategies.timestampFrom(adaptable), (DittoHeaders)PolicyEventMappingStrategies.dittoHeadersFrom(adaptable), (Metadata)PolicyEventMappingStrategies.metadataFrom(adaptable)));
    }

    private static long revisionFrom(Adaptable adaptable) {
        return adaptable.getPayload().getRevision().orElseThrow(() -> (JsonMissingFieldException)JsonMissingFieldException.newBuilder().fieldName((CharSequence)Payload.JsonFields.REVISION.getPointer().toString()).build());
    }

    @Nullable
    private static Instant timestampFrom(Adaptable adaptable) {
        return adaptable.getPayload().getTimestamp().orElse(null);
    }

    @Nullable
    private static Metadata metadataFrom(Adaptable adaptable) {
        return adaptable.getPayload().getMetadata().orElse(null);
    }
}

