/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.policies.model.PolicyId;
import org.eclipse.ditto.policies.model.SubjectId;
import org.eclipse.ditto.policies.model.signals.announcements.PolicyAnnouncement;
import org.eclipse.ditto.policies.model.signals.announcements.SubjectDeletionAnnouncement;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.mappingstrategies.AbstractPolicyMappingStrategies;

final class PolicyAnnouncementMappingStrategies
extends AbstractPolicyMappingStrategies<PolicyAnnouncement<?>> {
    private static final PolicyAnnouncementMappingStrategies INSTANCE = new PolicyAnnouncementMappingStrategies();

    private PolicyAnnouncementMappingStrategies() {
        super(PolicyAnnouncementMappingStrategies.initMappingStrategies());
    }

    public static PolicyAnnouncementMappingStrategies getInstance() {
        return INSTANCE;
    }

    private static Map<String, JsonifiableMapper<PolicyAnnouncement<?>>> initMappingStrategies() {
        HashMap mappingStrategies = new HashMap();
        mappingStrategies.put("policies.announcements:subjectDeletion", PolicyAnnouncementMappingStrategies::toSubjectDeletionAnnouncement);
        return mappingStrategies;
    }

    private static SubjectDeletionAnnouncement toSubjectDeletionAnnouncement(Adaptable adaptable) {
        PolicyId policyId = PolicyAnnouncementMappingStrategies.policyIdFromTopicPath(adaptable.getTopicPath());
        DittoHeaders dittoHeaders = PolicyAnnouncementMappingStrategies.dittoHeadersFrom(adaptable);
        JsonObject payload = PolicyAnnouncementMappingStrategies.getValueFromPayload(adaptable);
        Instant expiry = Instant.parse((CharSequence)payload.getValueOrThrow(SubjectDeletionAnnouncement.JsonFields.DELETE_AT));
        Set expiringSubjectIds = ((JsonArray)payload.getValueOrThrow(SubjectDeletionAnnouncement.JsonFields.SUBJECT_IDS)).stream().map(JsonValue::asString).map(SubjectId::newInstance).collect(Collectors.toCollection(LinkedHashSet::new));
        return SubjectDeletionAnnouncement.of((PolicyId)policyId, (Instant)expiry, (Collection)expiringSubjectIds, (DittoHeaders)dittoHeaders);
    }
}

