/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.messages.model.Message;
import org.eclipse.ditto.messages.model.MessageHeaders;
import org.eclipse.ditto.messages.model.signals.commands.MessageCommandResponse;
import org.eclipse.ditto.messages.model.signals.commands.SendClaimMessageResponse;
import org.eclipse.ditto.messages.model.signals.commands.SendFeatureMessageResponse;
import org.eclipse.ditto.messages.model.signals.commands.SendMessageAcceptedResponse;
import org.eclipse.ditto.messages.model.signals.commands.SendThingMessageResponse;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.mappingstrategies.AbstractMessageMappingStrategies;
import org.eclipse.ditto.things.model.ThingId;

final class MessageCommandResponseMappingStrategies
extends AbstractMessageMappingStrategies<MessageCommandResponse<?, ?>> {
    private static final MessageCommandResponseMappingStrategies INSTANCE = new MessageCommandResponseMappingStrategies();

    private MessageCommandResponseMappingStrategies() {
        super(MessageCommandResponseMappingStrategies.initMappingStrategies());
    }

    static MessageCommandResponseMappingStrategies getInstance() {
        return INSTANCE;
    }

    private static Map<String, JsonifiableMapper<MessageCommandResponse<?, ?>>> initMappingStrategies() {
        HashMap mappingStrategies = new HashMap();
        mappingStrategies.put("messages.responses:claimResponseMessage", adaptable -> SendClaimMessageResponse.of((ThingId)MessageCommandResponseMappingStrategies.thingIdFrom(adaptable), (Message)MessageCommandResponseMappingStrategies.messageFrom(adaptable), (HttpStatus)MessageCommandResponseMappingStrategies.getHttpStatus(adaptable), (DittoHeaders)MessageCommandResponseMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("messages.responses:thingResponseMessage", adaptable -> SendThingMessageResponse.of((ThingId)MessageCommandResponseMappingStrategies.thingIdFrom(adaptable), (Message)MessageCommandResponseMappingStrategies.messageFrom(adaptable), (HttpStatus)MessageCommandResponseMappingStrategies.getHttpStatus(adaptable), (DittoHeaders)MessageCommandResponseMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("messages.responses:featureResponseMessage", adaptable -> SendFeatureMessageResponse.of((ThingId)MessageCommandResponseMappingStrategies.thingIdFrom(adaptable), (String)MessageCommandResponseMappingStrategies.featureIdForMessageFrom(adaptable), (Message)MessageCommandResponseMappingStrategies.messageFrom(adaptable), (HttpStatus)MessageCommandResponseMappingStrategies.getHttpStatus(adaptable), (DittoHeaders)MessageCommandResponseMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("messages.responses:acceptedResponseMessage", adaptable -> SendMessageAcceptedResponse.newInstance((ThingId)MessageCommandResponseMappingStrategies.thingIdFrom(adaptable), (MessageHeaders)MessageCommandResponseMappingStrategies.messageHeadersFrom(adaptable), (HttpStatus)MessageCommandResponseMappingStrategies.getHttpStatus(adaptable), (DittoHeaders)MessageCommandResponseMappingStrategies.dittoHeadersFrom(adaptable)));
        return mappingStrategies;
    }

    protected static String featureIdForMessageFrom(Adaptable adaptable) {
        return adaptable.getPayload().getPath().getFeatureId().orElseThrow(() -> (JsonParseException)JsonParseException.newBuilder().build());
    }
}

