/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.messages.model.Message;
import org.eclipse.ditto.messages.model.signals.commands.MessageCommand;
import org.eclipse.ditto.messages.model.signals.commands.SendClaimMessage;
import org.eclipse.ditto.messages.model.signals.commands.SendFeatureMessage;
import org.eclipse.ditto.messages.model.signals.commands.SendThingMessage;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.mappingstrategies.AbstractMessageMappingStrategies;
import org.eclipse.ditto.things.model.ThingId;

final class MessageCommandMappingStrategies
extends AbstractMessageMappingStrategies<MessageCommand<?, ?>> {
    private static final MessageCommandMappingStrategies INSTANCE = new MessageCommandMappingStrategies();

    private MessageCommandMappingStrategies() {
        super(MessageCommandMappingStrategies.initMappingStrategies());
    }

    static MessageCommandMappingStrategies getInstance() {
        return INSTANCE;
    }

    private static Map<String, JsonifiableMapper<MessageCommand<?, ?>>> initMappingStrategies() {
        HashMap mappingStrategies = new HashMap();
        mappingStrategies.put("messages.commands:claimMessage", adaptable -> SendClaimMessage.of((ThingId)MessageCommandMappingStrategies.thingIdFrom(adaptable), (Message)MessageCommandMappingStrategies.messageFrom(adaptable), (DittoHeaders)MessageCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("messages.commands:thingMessage", adaptable -> SendThingMessage.of((ThingId)MessageCommandMappingStrategies.thingIdFrom(adaptable), (Message)MessageCommandMappingStrategies.messageFrom(adaptable), (DittoHeaders)MessageCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        mappingStrategies.put("messages.commands:featureMessage", adaptable -> SendFeatureMessage.of((ThingId)MessageCommandMappingStrategies.thingIdFrom(adaptable), (String)MessageCommandMappingStrategies.featureIdForMessageFrom(adaptable), (Message)MessageCommandMappingStrategies.messageFrom(adaptable), (DittoHeaders)MessageCommandMappingStrategies.dittoHeadersFrom(adaptable)));
        return mappingStrategies;
    }

    private static String featureIdForMessageFrom(Adaptable adaptable) {
        return adaptable.getPayload().getPath().getFeatureId().orElseThrow(() -> (JsonParseException)JsonParseException.newBuilder().build());
    }
}

