/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.policies.model.Label;
import org.eclipse.ditto.policies.model.PoliciesModelFactory;
import org.eclipse.ditto.policies.model.Policy;
import org.eclipse.ditto.policies.model.PolicyEntry;
import org.eclipse.ditto.policies.model.PolicyId;
import org.eclipse.ditto.policies.model.PolicyImport;
import org.eclipse.ditto.policies.model.PolicyImports;
import org.eclipse.ditto.policies.model.Resource;
import org.eclipse.ditto.policies.model.ResourceKey;
import org.eclipse.ditto.policies.model.Subject;
import org.eclipse.ditto.policies.model.SubjectId;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.MessagePath;
import org.eclipse.ditto.protocol.Payload;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.mappingstrategies.IllegalAdaptableException;
import org.eclipse.ditto.things.model.Attributes;
import org.eclipse.ditto.things.model.Feature;
import org.eclipse.ditto.things.model.FeatureDefinition;
import org.eclipse.ditto.things.model.FeatureProperties;
import org.eclipse.ditto.things.model.Features;
import org.eclipse.ditto.things.model.Thing;
import org.eclipse.ditto.things.model.ThingDefinition;
import org.eclipse.ditto.things.model.ThingId;
import org.eclipse.ditto.things.model.ThingsModelFactory;

final class MappingContext {
    private static final JsonKey ATTRIBUTE_PATH_PREFIX = JsonKey.of((CharSequence)"attributes");
    private static final JsonKey FEATURE_PATH_PREFIX = JsonKey.of((CharSequence)"features");
    private static final int FEATURE_PROPERTY_PATH_LEVEL = 3;
    private static final JsonKey POLICY_ENTRIES_PATH_PREFIX = JsonKey.of((CharSequence)"entries");
    private static final int RESOURCES_PATH_LEVEL = 2;
    private static final JsonKey RESOURCES_LEVEL_KEY = JsonKey.of((CharSequence)"resources");
    private static final int SUBJECTS_PATH_LEVEL = 2;
    private static final JsonKey SUBJECTS_LEVEL_KEY = JsonKey.of((CharSequence)"subjects");
    private static final int SUBJECT_PATH_LEVEL = 3;
    private static final int RESOURCE_PATH_LEVEL = 3;
    private final Adaptable adaptable;

    private MappingContext(Adaptable adaptable) {
        this.adaptable = adaptable;
    }

    public static MappingContext of(Adaptable adaptable) {
        return new MappingContext((Adaptable)ConditionChecker.checkNotNull((Object)adaptable, (String)"adaptable"));
    }

    Adaptable getAdaptable() {
        return this.adaptable;
    }

    DittoHeaders getDittoHeaders() {
        return this.adaptable.getDittoHeaders();
    }

    HttpStatus getHttpStatusOrThrow() {
        Payload payload = this.adaptable.getPayload();
        return payload.getHttpStatus().orElseThrow(() -> IllegalAdaptableException.newInstance("Payload does not contain a HTTP status.", "Please ensure that the payload of the Adaptable contains an expected HTTP status.", this.adaptable));
    }

    ThingId getThingId() {
        TopicPath topicPath = this.adaptable.getTopicPath();
        return ThingId.of((String)topicPath.getNamespace(), (String)topicPath.getEntityName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Optional<Thing> getThing() {
        Optional<JsonValue> payloadValueOptional = this.getPayloadValue();
        if (!payloadValueOptional.isPresent()) return Optional.empty();
        JsonValue jsonValue = payloadValueOptional.get();
        if (!jsonValue.isObject()) throw IllegalAdaptableException.newInstance(MessageFormat.format("Payload value is not a Thing as JSON object but <{0}>.", jsonValue), "Please ensure that the payload value is a valid Thing JSON object representation.", this.adaptable);
        return Optional.of(ThingsModelFactory.newThing((JsonObject)jsonValue.asObject()));
    }

    private Optional<JsonValue> getPayloadValue() {
        Payload payload = this.adaptable.getPayload();
        return payload.getValue();
    }

    Thing getThingOrThrow() {
        return this.getThing().orElseThrow(() -> IllegalAdaptableException.newInstance("Payload does not contain a Thing as JSON object because it has no value at all.", "Please ensure that the payload contains a valid Thing JSON object as value.", this.adaptable));
    }

    JsonObject getPayloadValueAsJsonObjectOrThrow() {
        Optional<JsonValue> payloadValue = this.getPayloadValue();
        if (payloadValue.isPresent()) {
            JsonValue jsonValue = payloadValue.get();
            if (jsonValue.isObject()) {
                return jsonValue.asObject();
            }
            throw IllegalAdaptableException.newInstance(MessageFormat.format("Payload value is not a JSON object but <{0}>.", jsonValue), "Please ensure that the payload value is a valid JSON object.", this.adaptable);
        }
        throw IllegalAdaptableException.newInstance("Payload does not contain a JSON object value because it has no value at all.", "Please ensure that the payload value contains a valid JSON object as value.", this.adaptable);
    }

    JsonPointer getAttributePointerOrThrow() {
        MessagePath messagePath = this.getMessagePath();
        if (!messagePath.getRoot().filter(arg_0 -> ((JsonKey)ATTRIBUTE_PATH_PREFIX).equals(arg_0)).isPresent()) {
            throw this.newMessagePathInvalidPrefixException((CharSequence)ATTRIBUTE_PATH_PREFIX.asPointer());
        }
        return messagePath.nextLevel();
    }

    private MessagePath getMessagePath() {
        Payload payload = this.adaptable.getPayload();
        return payload.getPath();
    }

    private IllegalAdaptableException newMessagePathInvalidPrefixException(CharSequence expectedPrefix) {
        return IllegalAdaptableException.newInstance(MessageFormat.format("Message path of payload does not start with <{0}>.", expectedPrefix), MessageFormat.format("Please ensure that the message path of the Adaptable starts with <{0}>.", expectedPrefix), this.adaptable);
    }

    Optional<JsonValue> getAttributeValue() {
        return this.getPayloadValue();
    }

    JsonValue getAttributeValueOrThrow() {
        return this.getAttributeValue().orElseThrow(() -> IllegalAdaptableException.newInstance("Payload does not contain an attribute value.", "Please ensure that the payload of the Adaptable contains an attribute value.", this.adaptable));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Optional<Attributes> getAttributes() {
        Optional<JsonValue> payloadValueOptional = this.getPayloadValue();
        if (!payloadValueOptional.isPresent()) return Optional.empty();
        JsonValue jsonValue = payloadValueOptional.get();
        if (!jsonValue.isObject()) throw IllegalAdaptableException.newInstance(MessageFormat.format("Payload value is not an {0} as JSON object but <{1}>.", Attributes.class.getSimpleName(), jsonValue), this.adaptable);
        return Optional.of(ThingsModelFactory.newAttributes((JsonObject)jsonValue.asObject()));
    }

    Attributes getAttributesOrThrow() {
        return this.getAttributes().orElseThrow(() -> IllegalAdaptableException.newInstance("Payload does not contain an Attributes as JSON object because it has no value at all.", "Please ensure that the payload contains a valid Attributes JSON object as value.", this.adaptable));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Optional<Features> getFeatures() {
        Optional<JsonValue> payloadValueOptional = this.getPayloadValue();
        if (!payloadValueOptional.isPresent()) return Optional.empty();
        JsonValue jsonValue = payloadValueOptional.get();
        if (!jsonValue.isObject()) throw this.newPayloadValueNotJsonObjectException(Features.class, jsonValue);
        return Optional.of(ThingsModelFactory.newFeatures((JsonObject)jsonValue.asObject()));
    }

    private IllegalAdaptableException newPayloadValueNotJsonObjectException(Class<?> targetType, JsonValue jsonValue) {
        return IllegalAdaptableException.newInstance(MessageFormat.format("Payload value is not a {0} as JSON object but <{1}>.", targetType.getSimpleName(), jsonValue), MessageFormat.format("Please ensure that the payload value is a JSON object representation of <{0}>.", targetType), this.adaptable);
    }

    Features getFeaturesOrThrow() {
        return this.getFeatures().orElseThrow(() -> IllegalAdaptableException.newInstance("Payload does not contain a Features as JSON string object it has no value at all.", "Please ensure that the payload contains a valid Features JSON object as value.", this.adaptable));
    }

    String getFeatureIdOrThrow() {
        MessagePath messagePath = this.getMessagePath();
        if (!messagePath.getRoot().filter(arg_0 -> ((JsonKey)FEATURE_PATH_PREFIX).equals(arg_0)).isPresent()) {
            throw this.newMessagePathInvalidPrefixException((CharSequence)FEATURE_PATH_PREFIX.asPointer());
        }
        return messagePath.get(1).map(CharSequence::toString).orElseThrow(() -> IllegalAdaptableException.newInstance("Message path of payload does not contain a feature ID.", MessageFormat.format("Please ensure that the message path of the payload consists of two segments, starting with {0}/ and ending with the feature ID.", FEATURE_PATH_PREFIX), this.adaptable));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Optional<Feature> getFeature() {
        void var1_8;
        Optional<JsonValue> payloadValueOptional = this.getPayloadValue();
        if (payloadValueOptional.isPresent()) {
            JsonValue jsonValue = payloadValueOptional.get();
            if (!jsonValue.isObject()) throw this.newPayloadValueNotJsonObjectException(Feature.class, jsonValue);
            JsonObject jsonObject = jsonValue.asObject();
            if (jsonObject.isNull()) {
                Optional optional = Optional.empty();
                return var1_8;
            } else {
                Optional<Feature> optional = Optional.of(ThingsModelFactory.newFeatureBuilder((JsonObject)jsonObject).useId(this.getFeatureIdOrThrow()).build());
            }
            return var1_8;
        } else {
            Optional optional = Optional.empty();
        }
        return var1_8;
    }

    Feature getFeatureOrThrow() {
        return this.getFeature().orElseThrow(() -> IllegalAdaptableException.newInstance("Payload does not contain a Feature as JSON object it has no value at all.", "Please ensure that the payload contains a valid Feature JSON object as value.", this.adaptable));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Optional<ThingDefinition> getThingDefinition() {
        Optional<JsonValue> payloadValueOptional = this.getPayloadValue();
        if (!payloadValueOptional.isPresent()) return Optional.empty();
        JsonValue jsonValue = payloadValueOptional.get();
        if (!jsonValue.isString()) throw IllegalAdaptableException.newInstance(MessageFormat.format("Payload value is not a {0} as JSON string but <{1}>.", ThingDefinition.class.getSimpleName(), jsonValue), this.adaptable);
        return Optional.of(ThingsModelFactory.newDefinition((CharSequence)jsonValue.asString()));
    }

    ThingDefinition getThingDefinitionOrThrow() {
        return this.getThingDefinition().orElseThrow(() -> IllegalAdaptableException.newInstance("Payload does not contain a ThingDefinition as JSON string because it has no value at all.", "Please ensure that the payload contains a valid ThingDefinition JSON string as value.", this.adaptable));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Optional<FeatureDefinition> getFeatureDefinition() {
        Optional<JsonValue> payloadValueOptional = this.getPayloadValue();
        if (!payloadValueOptional.isPresent()) return Optional.empty();
        JsonValue jsonValue = payloadValueOptional.get();
        if (!jsonValue.isArray()) throw IllegalAdaptableException.newInstance(MessageFormat.format("Payload value is not a {0} as JSON array but <{1}>.", FeatureDefinition.class.getSimpleName(), jsonValue), this.adaptable);
        return Optional.of(ThingsModelFactory.newFeatureDefinition((JsonArray)jsonValue.asArray()));
    }

    FeatureDefinition getFeatureDefinitionOrThrow() {
        return this.getFeatureDefinition().orElseThrow(() -> IllegalAdaptableException.newInstance("Payload does not contain a FeatureDefinition as JSON array because it has no value at all.", "Please ensure that the payload contains a valid FeatureDefinition JSON array as value.", this.adaptable));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Optional<FeatureProperties> getFeatureProperties() {
        Optional<JsonValue> payloadValueOptional = this.getPayloadValue();
        if (!payloadValueOptional.isPresent()) return Optional.empty();
        JsonValue jsonValue = payloadValueOptional.get();
        if (!jsonValue.isObject()) throw this.newPayloadValueNotJsonObjectException(FeatureProperties.class, jsonValue);
        return Optional.of(ThingsModelFactory.newFeatureProperties((JsonObject)jsonValue.asObject()));
    }

    FeatureProperties getFeaturePropertiesOrThrow() {
        return this.getFeatureProperties().orElseThrow(() -> IllegalAdaptableException.newInstance("Payload does not contain a FeatureProperties as JSON object it has no value at all.", "Please ensure that the payload contains a valid FeatureProperties JSON object as value.", this.adaptable));
    }

    JsonPointer getFeaturePropertyPointerOrThrow() {
        return this.getFeaturePropertyPointerOrThrow(JsonKey.of((CharSequence)"properties"));
    }

    private JsonPointer getFeaturePropertyPointerOrThrow(JsonKey levelTwoKey) {
        String schema = "\"features/${FEATURE_ID}/properties/${PROPERTY_SUB_PATH_OR_PROPERTY_NAME}\"";
        HashMap<Integer, JsonKey> expectedPathSegments = new HashMap<Integer, JsonKey>();
        expectedPathSegments.put(0, FEATURE_PATH_PREFIX);
        expectedPathSegments.put(2, levelTwoKey);
        this.validateMessagePathSegments(expectedPathSegments, "\"features/${FEATURE_ID}/properties/${PROPERTY_SUB_PATH_OR_PROPERTY_NAME}\"");
        MessagePath messagePath = this.getMessagePath();
        return (JsonPointer)messagePath.getSubPointer(3).orElseThrow(() -> IllegalAdaptableException.newInstance(MessageFormat.format("Message path of payload does not contain a sub-pointer at level <{0,number}>.", 3), MessageFormat.format("Please ensure that the message path complies to schema {0}.", "\"features/${FEATURE_ID}/properties/${PROPERTY_SUB_PATH_OR_PROPERTY_NAME}\""), this.adaptable));
    }

    private void validateMessagePathSegments(Map<Integer, JsonKey> expectedSegments, String schema) {
        MessagePath messagePath = this.getMessagePath();
        List messagePathAsList = StreamSupport.stream(messagePath.spliterator(), false).collect(Collectors.toList());
        expectedSegments.forEach((level, expectedJsonKey) -> {
            JsonKey actualJsonKey = (JsonKey)messagePathAsList.get((int)level);
            if (!Objects.equals(actualJsonKey, expectedJsonKey)) {
                String message = 0 == level ? MessageFormat.format("Message path of payload does not start with <{0}>.", expectedJsonKey.asPointer()) : MessageFormat.format("Message path of payload at level <{1, number}> is not <{0}> but <{2}>.", expectedJsonKey, level, actualJsonKey);
                throw IllegalAdaptableException.newInstance(message, MessageFormat.format("Please ensure that the message path complies to schema {0}.", schema), this.adaptable);
            }
        });
    }

    JsonPointer getFeatureDesiredPropertyPointerOrThrow() {
        return this.getFeaturePropertyPointerOrThrow(JsonKey.of((CharSequence)"desiredProperties"));
    }

    Optional<JsonValue> getFeaturePropertyValue() {
        return this.getPayloadValue();
    }

    JsonValue getFeaturePropertyValueOrThrow() {
        return this.getFeaturePropertyValue().orElseThrow(() -> IllegalAdaptableException.newInstance("Payload does not contain a feature property value because it has no value at all.", "Please ensure that the payload contains a JSON value as value.", this.adaptable));
    }

    Optional<String> getNamespace() {
        TopicPath topicPath = this.adaptable.getTopicPath();
        String namespace = topicPath.getNamespace();
        Optional<Object> result = "_".equals(namespace) ? Optional.empty() : Optional.of(namespace);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Optional<PolicyId> getPolicyId() {
        Optional<JsonValue> payloadValueOptional = this.getPayloadValue();
        if (!payloadValueOptional.isPresent()) return Optional.empty();
        JsonValue jsonValue = payloadValueOptional.get();
        if (!jsonValue.isString()) throw IllegalAdaptableException.newInstance(MessageFormat.format("Payload value is not a {0} as JSON string but <{1}>.", PolicyId.class.getSimpleName(), jsonValue), this.adaptable);
        return Optional.of(PolicyId.of((CharSequence)jsonValue.asString()));
    }

    PolicyId getPolicyIdOrThrow() {
        return this.getPolicyId().orElseThrow(() -> IllegalAdaptableException.newInstance("Payload does not contain a PolicyId as JSON string because it has no value at all.", "Please ensure that the payload contains a valid PolicyId JSON string value as value.", this.adaptable));
    }

    PolicyId getPolicyIdFromTopicPath() {
        TopicPath topicPath = this.adaptable.getTopicPath();
        String namespace = topicPath.getNamespace();
        String entityName = topicPath.getEntityName();
        return PolicyId.of((String)namespace, (String)entityName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Optional<Policy> getPolicy() {
        Optional<JsonValue> payloadValueOptional = this.getPayloadValue();
        if (!payloadValueOptional.isPresent()) return Optional.empty();
        JsonValue jsonValue = payloadValueOptional.get();
        if (!jsonValue.isObject()) throw this.newPayloadValueNotJsonObjectException(Policy.class, jsonValue);
        return Optional.of(PoliciesModelFactory.newPolicy((JsonObject)jsonValue.asObject()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Optional<PolicyEntry> getPolicyEntry() {
        Optional<JsonValue> payloadValueOptional = this.getPayloadValue();
        if (!payloadValueOptional.isPresent()) return Optional.empty();
        JsonValue jsonValue = payloadValueOptional.get();
        if (!jsonValue.isObject()) throw this.newPayloadValueNotJsonObjectException(PolicyEntry.class, jsonValue);
        return Optional.of(PoliciesModelFactory.newPolicyEntry((CharSequence)this.getLabelOrThrow(), (JsonObject)jsonValue.asObject()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Optional<PolicyImports> getPolicyImports() {
        Optional<JsonValue> payloadValueOptional = this.getPayloadValue();
        if (!payloadValueOptional.isPresent()) return Optional.empty();
        JsonValue jsonValue = payloadValueOptional.get();
        if (!jsonValue.isObject()) throw this.newPayloadValueNotJsonObjectException(PolicyImports.class, jsonValue);
        return Optional.of(PoliciesModelFactory.newPolicyImports((JsonObject)jsonValue.asObject()));
    }

    PolicyId getImportedPolicyId() {
        MessagePath path = this.adaptable.getPayload().getPath();
        return path.getRoot().filter(entries -> Policy.JsonFields.IMPORTS.getPointer().equals((Object)entries.asPointer())).map(entries -> path.nextLevel()).flatMap(JsonPointer::getRoot).map(CharSequence::toString).map(PolicyId::of).orElseThrow(() -> (JsonParseException)JsonParseException.newBuilder().build());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Optional<PolicyImport> getPolicyImport() {
        Optional<JsonValue> payloadValueOptional = this.getPayloadValue();
        if (!payloadValueOptional.isPresent()) return Optional.empty();
        JsonValue jsonValue = payloadValueOptional.get();
        if (!jsonValue.isObject()) throw this.newPayloadValueNotJsonObjectException(PolicyImports.class, jsonValue);
        return Optional.of(PoliciesModelFactory.newPolicyImport((PolicyId)this.getPolicyIdOrThrow(), (JsonObject)jsonValue.asObject()));
    }

    Label getLabelOrThrow() {
        MessagePath messagePath = this.getMessagePath();
        JsonPointer labelSubPath = messagePath.getRoot().filter(arg_0 -> ((JsonKey)POLICY_ENTRIES_PATH_PREFIX).equals(arg_0)).map(root -> messagePath.nextLevel()).orElseThrow(() -> this.newMessagePathInvalidPrefixException((CharSequence)POLICY_ENTRIES_PATH_PREFIX.asPointer()));
        return labelSubPath.getRoot().map(PoliciesModelFactory::newLabel).orElseThrow(() -> IllegalAdaptableException.newInstance("Path does not contain a policy label.", "Please ensure that the path of the Adaptable contains a policy label.", this.adaptable));
    }

    ResourceKey getResourceKeyOrThrow() {
        String schema = "\"entries/${POLICY_LABEL}/resources/${RESOURCE_KEY}\"";
        HashMap<Integer, JsonKey> expectedSegments = new HashMap<Integer, JsonKey>();
        expectedSegments.put(0, POLICY_ENTRIES_PATH_PREFIX);
        expectedSegments.put(2, RESOURCES_LEVEL_KEY);
        this.validateMessagePathSegments(expectedSegments, "\"entries/${POLICY_LABEL}/resources/${RESOURCE_KEY}\"");
        MessagePath messagePath = this.getMessagePath();
        return messagePath.getSubPointer(3).map(PoliciesModelFactory::newResourceKey).orElseThrow(() -> IllegalAdaptableException.newInstance(MessageFormat.format("Message messagePath of payload does have resource key at level <{0,number}>.", 3), "Please ensure that the message path complies to schema \"entries/${POLICY_LABEL}/resources/${RESOURCE_KEY}\".", this.adaptable));
    }

    Optional<Resource> getResource() {
        return this.getPayloadValue().map(jsonValue -> Resource.newInstance((ResourceKey)this.getResourceKeyOrThrow(), (JsonValue)jsonValue));
    }

    SubjectId getSubjectIdOrThrow() {
        String schema = "\"entries/${POLICY_LABEL}/subjects/${SUBJECT_ID}\"";
        HashMap<Integer, JsonKey> expectedPathSegments = new HashMap<Integer, JsonKey>();
        expectedPathSegments.put(0, JsonKey.of((CharSequence)POLICY_ENTRIES_PATH_PREFIX));
        expectedPathSegments.put(2, SUBJECTS_LEVEL_KEY);
        this.validateMessagePathSegments(expectedPathSegments, "\"entries/${POLICY_LABEL}/subjects/${SUBJECT_ID}\"");
        MessagePath messagePath = this.getMessagePath();
        return messagePath.get(3).map(PoliciesModelFactory::newSubjectId).orElseThrow(() -> IllegalAdaptableException.newInstance(MessageFormat.format("Message path of payload does not contain a subject ID at level <{0,number}>.", 3), "Please ensure that message path complies to schema \"entries/${POLICY_LABEL}/subjects/${SUBJECT_ID}\".", this.adaptable));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Optional<Subject> getSubject() {
        Optional<JsonValue> payloadValueOptional = this.getPayloadValue();
        if (!payloadValueOptional.isPresent()) return Optional.empty();
        JsonValue jsonValue = payloadValueOptional.get();
        if (!jsonValue.isObject()) throw this.newPayloadValueNotJsonObjectException(Subject.class, jsonValue);
        return Optional.of(PoliciesModelFactory.newSubject((CharSequence)this.getSubjectIdOrThrow(), (JsonObject)jsonValue.asObject()));
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappingContext that = (MappingContext)o;
        return Objects.equals(this.adaptable, that.adaptable);
    }

    public int hashCode() {
        return Objects.hash(this.adaptable);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [adaptable=" + this.adaptable + "]";
    }
}

