/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.net.URI;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.FieldType;
import org.eclipse.ditto.base.model.json.JsonParsableException;
import org.eclipse.ditto.base.model.json.JsonSchemaVersion;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.ProtocolAdapterException;
import org.eclipse.ditto.protocol.ProtocolFactory;
import org.eclipse.ditto.protocol.TopicPath;

@JsonParsableException(errorCode="protocoladapter:illegal.adaptable")
public final class IllegalAdaptableException
extends DittoRuntimeException
implements ProtocolAdapterException {
    public static final String ERROR_CODE = "protocoladapter:illegal.adaptable";
    static final String DEFAULT_DESCRIPTION = "Please ensure that the Adaptable matches the expectations.";
    static final HttpStatus HTTP_STATUS = HttpStatus.UNPROCESSABLE_ENTITY;
    static final JsonFieldDefinition<String> JSON_FIELD_TOPIC_PATH = JsonFieldDefinition.ofString((CharSequence)"topicPath", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    static final JsonFieldDefinition<String> JSON_FIELD_SIGNAL_TYPE = JsonFieldDefinition.ofString((CharSequence)"signalType", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    private static final long serialVersionUID = 1552465013185426687L;
    private final transient TopicPath topicPath;
    @Nullable
    private final transient CharSequence signalType;

    private IllegalAdaptableException(String errorCode, HttpStatus httpStatus, DittoHeaders dittoHeaders, Builder builder) {
        super(errorCode, httpStatus, dittoHeaders, builder.message, builder.description, builder.cause, builder.href);
        this.topicPath = builder.topicPath;
        this.signalType = builder.signalType;
    }

    public static IllegalAdaptableException newInstance(String message, Adaptable adaptable) {
        return IllegalAdaptableException.newInstance(message, DEFAULT_DESCRIPTION, adaptable);
    }

    public static IllegalAdaptableException newInstance(String message, @Nullable String description, Adaptable adaptable) {
        return IllegalAdaptableException.newBuilder(message, adaptable).withDescription(description).build();
    }

    public static Builder newBuilder(String message, Adaptable adaptable) {
        ConditionChecker.checkNotNull((Object)adaptable, (String)"adaptable");
        return new Builder(message, adaptable.getTopicPath(), adaptable.getDittoHeaders());
    }

    public static IllegalAdaptableException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        ConditionChecker.checkNotNull((Object)jsonObject, (String)"jsonObject");
        try {
            return new IllegalAdaptableException(IllegalAdaptableException.deserializeErrorCode(jsonObject), IllegalAdaptableException.deserializeHttpStatus(jsonObject), dittoHeaders, new Builder((String)jsonObject.getValueOrThrow(DittoRuntimeException.JsonFields.MESSAGE), IllegalAdaptableException.deserializeTopicPath(jsonObject), dittoHeaders).withSignalType(IllegalAdaptableException.deserializeSignalType(jsonObject).orElse(null)).withDescription(jsonObject.getValue(DittoRuntimeException.JsonFields.DESCRIPTION).orElse(null)).withHref(IllegalAdaptableException.deserializeHref(jsonObject).orElse(null)));
        }
        catch (Exception e) {
            throw (JsonParseException)JsonParseException.newBuilder().message(MessageFormat.format("Failed to deserialize JSON object to a {0}: {1}", IllegalAdaptableException.class.getSimpleName(), e.getMessage())).cause((Throwable)e).build();
        }
    }

    private static String deserializeErrorCode(JsonObject jsonObject) {
        JsonFieldDefinition fieldDefinition = DittoRuntimeException.JsonFields.ERROR_CODE;
        String result = (String)jsonObject.getValueOrThrow(fieldDefinition);
        if (!ERROR_CODE.equals(result)) {
            throw new JsonParseException(MessageFormat.format("Error code <{0}> of field <{1}> differs from the expected <{2}>.", result, fieldDefinition.getPointer(), ERROR_CODE));
        }
        return result;
    }

    private static HttpStatus deserializeHttpStatus(JsonObject jsonObject) {
        JsonFieldDefinition fieldDefinition = DittoRuntimeException.JsonFields.STATUS;
        Integer statusCode = (Integer)jsonObject.getValueOrThrow(fieldDefinition);
        if (!Objects.equals(HTTP_STATUS.getCode(), statusCode)) {
            throw new JsonParseException(MessageFormat.format("HTTP status code <{0}> of field <{1}> differs from the expected <{2}>.", statusCode, fieldDefinition.getPointer(), HTTP_STATUS.getCode()));
        }
        return HTTP_STATUS;
    }

    private static TopicPath deserializeTopicPath(JsonObject jsonObject) {
        String deserializedTopicPathOptional = (String)jsonObject.getValueOrThrow(JSON_FIELD_TOPIC_PATH);
        return ProtocolFactory.newTopicPath(deserializedTopicPathOptional);
    }

    private static Optional<String> deserializeSignalType(JsonObject jsonObject) {
        JsonFieldDefinition<String> fieldDefinition = JSON_FIELD_SIGNAL_TYPE;
        Optional deserializedSignalTypeOptional = jsonObject.getValue(fieldDefinition);
        if (deserializedSignalTypeOptional.isPresent() && IllegalAdaptableException.isBlank((CharSequence)deserializedSignalTypeOptional.get())) {
            throw new JsonParseException(MessageFormat.format("Value of field <{0}> must not be blank.", fieldDefinition.getPointer()));
        }
        Optional result = deserializedSignalTypeOptional;
        return result;
    }

    private static boolean isBlank(CharSequence charSequence) {
        return 0L == charSequence.chars().filter(ch -> !Character.isWhitespace(ch)).count();
    }

    private static Optional<URI> deserializeHref(JsonObject jsonObject) {
        JsonFieldDefinition fieldDefinition = DittoRuntimeException.JsonFields.HREF;
        try {
            return jsonObject.getValue(fieldDefinition).map(URI::create);
        }
        catch (IllegalArgumentException e) {
            throw (JsonParseException)JsonParseException.newBuilder().message(MessageFormat.format("Syntax of link URI of field <{0}> is invalid: {1}", fieldDefinition.getPointer(), e.getMessage())).cause((Throwable)e).build();
        }
    }

    public TopicPath getTopicPath() {
        return this.topicPath;
    }

    public Optional<String> getSignalType() {
        return Optional.ofNullable(this.signalType).map(CharSequence::toString);
    }

    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new IllegalAdaptableException(this.getErrorCode(), this.getHttpStatus(), dittoHeaders, new Builder(this.getMessage(), this.topicPath, dittoHeaders).withSignalType(this.signalType).withDescription(this.getDescription().orElse(null)).withCause(this.getCause()).withHref(this.getHref().orElse(null)));
    }

    protected void appendToJson(JsonObjectBuilder jsonObjectBuilder, Predicate<JsonField> predicate) {
        jsonObjectBuilder.set(JSON_FIELD_TOPIC_PATH, (Object)this.topicPath.getPath());
        if (null != this.signalType) {
            jsonObjectBuilder.set(JSON_FIELD_SIGNAL_TYPE, (Object)this.signalType.toString());
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IllegalAdaptableException that = (IllegalAdaptableException)o;
        return Objects.equals(this.topicPath, that.topicPath) && Objects.equals(this.signalType, that.signalType);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.topicPath, this.signalType);
    }

    @NotThreadSafe
    public static final class Builder {
        private final String message;
        private final TopicPath topicPath;
        private final DittoHeaders dittoHeaders;
        @Nullable
        private CharSequence signalType;
        @Nullable
        private String description;
        @Nullable
        private Throwable cause;
        @Nullable
        private URI href;

        private Builder(String message, TopicPath topicPath, DittoHeaders dittoHeaders) {
            this.message = Builder.checkCharSequenceArgumentNotBlank(message, "message");
            this.topicPath = (TopicPath)ConditionChecker.checkNotNull((Object)topicPath, (String)"topicPath");
            this.dittoHeaders = (DittoHeaders)ConditionChecker.checkNotNull((Object)dittoHeaders, (String)"dittoHeaders");
        }

        private static <T extends CharSequence> T checkCharSequenceArgumentNotBlank(T charSequence, String argumentName) {
            return (T)((CharSequence)ConditionChecker.checkArgument((Object)((CharSequence)ConditionChecker.checkNotNull(charSequence, (String)argumentName)), argument -> !IllegalAdaptableException.isBlank(charSequence), () -> MessageFormat.format("The {0} must not be blank.", argumentName)));
        }

        public Builder withSignalType(@Nullable CharSequence signalType) {
            if (null != signalType) {
                Builder.checkCharSequenceArgumentNotBlank(signalType, "signalType");
            }
            this.signalType = signalType;
            return this;
        }

        public Builder withDescription(@Nullable String description) {
            this.description = description;
            return this;
        }

        public Builder withCause(@Nullable Throwable cause) {
            this.cause = cause;
            return this;
        }

        public Builder withHref(@Nullable URI href) {
            this.href = href;
            return this;
        }

        public IllegalAdaptableException build() {
            return new IllegalAdaptableException(IllegalAdaptableException.ERROR_CODE, HTTP_STATUS, this.dittoHeaders, this);
        }
    }
}

