/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.text.MessageFormat;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.connectivity.model.ConnectionId;
import org.eclipse.ditto.connectivity.model.signals.announcements.ConnectionClosedAnnouncement;
import org.eclipse.ditto.connectivity.model.signals.announcements.ConnectionOpenedAnnouncement;
import org.eclipse.ditto.connectivity.model.signals.announcements.ConnectivityAnnouncement;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.mappingstrategies.AbstractConnectivityMappingStrategies;

final class ConnectivityAnnouncementMappingStrategies
extends AbstractConnectivityMappingStrategies<ConnectivityAnnouncement<?>> {
    private static final ConnectivityAnnouncementMappingStrategies INSTANCE = new ConnectivityAnnouncementMappingStrategies();

    private ConnectivityAnnouncementMappingStrategies() {
        super(ConnectivityAnnouncementMappingStrategies.initMappingStrategies());
    }

    public static ConnectivityAnnouncementMappingStrategies getInstance() {
        return INSTANCE;
    }

    private static Map<String, JsonifiableMapper<ConnectivityAnnouncement<?>>> initMappingStrategies() {
        HashMap mappingStrategies = new HashMap();
        mappingStrategies.put("connectivity.announcements:opened", ConnectivityAnnouncementMappingStrategies::toConnectionOpenedAnnouncement);
        mappingStrategies.put("connectivity.announcements:closed", ConnectivityAnnouncementMappingStrategies::toConnectionClosedAnnouncement);
        return mappingStrategies;
    }

    private static ConnectionOpenedAnnouncement toConnectionOpenedAnnouncement(Adaptable adaptable) {
        ConnectionId connectionId = ConnectivityAnnouncementMappingStrategies.connectionIdFromTopicPath(adaptable.getTopicPath());
        DittoHeaders dittoHeaders = ConnectivityAnnouncementMappingStrategies.dittoHeadersFrom(adaptable);
        JsonObject payload = ConnectivityAnnouncementMappingStrategies.getValueFromPayload(adaptable);
        Instant openedAt = ConnectivityAnnouncementMappingStrategies.deserializeInstant(payload, (JsonFieldDefinition<String>)ConnectionOpenedAnnouncement.JsonFields.OPENED_AT);
        return ConnectionOpenedAnnouncement.of((ConnectionId)connectionId, (Instant)openedAt, (DittoHeaders)dittoHeaders);
    }

    private static ConnectionClosedAnnouncement toConnectionClosedAnnouncement(Adaptable adaptable) {
        ConnectionId connectionId = ConnectivityAnnouncementMappingStrategies.connectionIdFromTopicPath(adaptable.getTopicPath());
        DittoHeaders dittoHeaders = ConnectivityAnnouncementMappingStrategies.dittoHeadersFrom(adaptable);
        JsonObject payload = ConnectivityAnnouncementMappingStrategies.getValueFromPayload(adaptable);
        Instant closedAt = ConnectivityAnnouncementMappingStrategies.deserializeInstant(payload, (JsonFieldDefinition<String>)ConnectionClosedAnnouncement.JsonFields.CLOSED_AT);
        return ConnectionClosedAnnouncement.of((ConnectionId)connectionId, (Instant)closedAt, (DittoHeaders)dittoHeaders);
    }

    private static Instant deserializeInstant(JsonObject jsonObject, JsonFieldDefinition<String> fieldDefinition) {
        String instantString = (String)jsonObject.getValueOrThrow(fieldDefinition);
        try {
            return Instant.parse(instantString);
        }
        catch (DateTimeParseException e) {
            throw (JsonParseException)JsonParseException.newBuilder().message(MessageFormat.format("Failed to deserialize field <{0}> with value <{1}> as {2}: {3}", fieldDefinition.getPointer(), instantString, Instant.class, e.getMessage())).description("Timestamp must be provided as ISO-8601 formatted char sequence.").build();
        }
    }
}

