/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.text.MessageFormat;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.signals.Signal;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.mappingstrategies.IllegalAdaptableException;
import org.eclipse.ditto.protocol.mappingstrategies.MappingContext;

final class AdaptableToSignalMapper<T extends Signal<?>>
implements JsonifiableMapper<T> {
    private final String signalType;
    private final Function<MappingContext, T> mappingFunction;

    private AdaptableToSignalMapper(String signalType, Function<MappingContext, T> mappingFunction) {
        this.signalType = signalType;
        this.mappingFunction = mappingFunction;
    }

    static <T extends Signal<?>> AdaptableToSignalMapper<T> of(CharSequence signalType, Function<MappingContext, T> mappingFunction) {
        return new AdaptableToSignalMapper<T>((String)ConditionChecker.checkArgument((Object)((CharSequence)ConditionChecker.checkNotNull((Object)signalType, (String)"signalType")).toString(), arg -> !arg.trim().isEmpty(), () -> "The signalType must not be blank."), (Function)ConditionChecker.checkNotNull(mappingFunction, (String)"mappingFunction"));
    }

    @Override
    public T map(Adaptable adaptable) {
        return this.tryToMapAdaptableToSignal(adaptable);
    }

    private T tryToMapAdaptableToSignal(Adaptable adaptable) {
        try {
            return (T)((Signal)this.mappingFunction.apply(MappingContext.of(adaptable)));
        }
        catch (DittoRuntimeException e) {
            throw IllegalAdaptableException.newBuilder(this.getDetailMessage(adaptable, e), adaptable).withDescription(e.getDescription().orElse(null)).withSignalType(this.signalType).withCause(e).build();
        }
        catch (Exception e) {
            throw IllegalAdaptableException.newBuilder(this.getDetailMessage(adaptable, e), adaptable).withSignalType(this.signalType).withCause(e).build();
        }
    }

    private String getDetailMessage(Adaptable adaptable, Throwable cause) {
        return MessageFormat.format("Failed to get Signal of type <{0}> for <{1}>: {2}", this.signalType, adaptable, cause.getMessage());
    }

    String getSignalType() {
        return this.signalType;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdaptableToSignalMapper that = (AdaptableToSignalMapper)o;
        return Objects.equals(this.signalType, that.signalType) && Objects.equals(this.mappingFunction, that.mappingFunction);
    }

    public int hashCode() {
        return Objects.hash(this.signalType, this.mappingFunction);
    }
}

