/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.util.Map;
import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.json.Jsonifiable;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.policies.model.PolicyId;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.MessagePath;
import org.eclipse.ditto.protocol.UnknownPathException;
import org.eclipse.ditto.protocol.mappingstrategies.AbstractMappingStrategies;
import org.eclipse.ditto.things.model.Attributes;
import org.eclipse.ditto.things.model.Feature;
import org.eclipse.ditto.things.model.FeatureDefinition;
import org.eclipse.ditto.things.model.FeatureProperties;
import org.eclipse.ditto.things.model.Features;
import org.eclipse.ditto.things.model.Thing;
import org.eclipse.ditto.things.model.ThingDefinition;
import org.eclipse.ditto.things.model.ThingsModelFactory;

abstract class AbstractThingMappingStrategies<T extends Jsonifiable.WithPredicate<JsonObject, JsonField>>
extends AbstractMappingStrategies<T> {
    private static final int ATTRIBUTE_PATH_LEVEL = 1;
    private static final int FEATURE_PATH_LEVEL = 1;
    private static final int FEATURE_PROPERTY_PATH_LEVEL = 3;

    protected AbstractThingMappingStrategies(Map<String, JsonifiableMapper<T>> mappingStrategies) {
        super(mappingStrategies);
    }

    @Nullable
    protected static String namespaceFrom(Adaptable adaptable) {
        String namespace = adaptable.getTopicPath().getNamespace();
        return "_".equals(namespace) ? null : namespace;
    }

    protected static JsonObject payloadValueAsJsonObjectFrom(Adaptable adaptable) {
        return adaptable.getPayload().getValue().map(JsonValue::asObject).orElseThrow(() -> (JsonParseException)JsonParseException.newBuilder().build());
    }

    protected static Thing thingFrom(Adaptable adaptable) {
        return adaptable.getPayload().getValue().map(JsonValue::asObject).map(ThingsModelFactory::newThing).orElseThrow(() -> (JsonParseException)JsonParseException.newBuilder().build());
    }

    protected static Attributes attributesFrom(Adaptable adaptable) {
        return adaptable.getPayload().getValue().map(JsonValue::asObject).map(ThingsModelFactory::newAttributes).orElseThrow(() -> (JsonParseException)JsonParseException.newBuilder().build());
    }

    protected static JsonPointer attributePointerFrom(Adaptable adaptable) {
        MessagePath path = adaptable.getPayload().getPath();
        return (JsonPointer)path.getSubPointer(1).orElseThrow(() -> (UnknownPathException)UnknownPathException.newBuilder(path).build());
    }

    protected static JsonValue attributeValueFrom(Adaptable adaptable) {
        return adaptable.getPayload().getValue().orElseThrow(() -> (JsonParseException)JsonParseException.newBuilder().build());
    }

    protected static String featureIdFrom(Adaptable adaptable) {
        MessagePath path = adaptable.getPayload().getPath();
        return ((JsonKey)path.get(1).orElseThrow(() -> (UnknownPathException)UnknownPathException.newBuilder(path).build())).toString();
    }

    protected static Features featuresFrom(Adaptable adaptable) {
        return adaptable.getPayload().getValue().map(JsonValue::asObject).map(ThingsModelFactory::newFeatures).orElseThrow(() -> (JsonParseException)JsonParseException.newBuilder().build());
    }

    protected static Feature featureFrom(Adaptable adaptable) {
        return adaptable.getPayload().getValue().map(JsonValue::asObject).map(jsonObject -> ThingsModelFactory.newFeatureBuilder((JsonObject)jsonObject).useId(AbstractThingMappingStrategies.featureIdFrom(adaptable)).build()).orElseThrow(() -> (JsonParseException)JsonParseException.newBuilder().build());
    }

    protected static FeatureDefinition featureDefinitionFrom(Adaptable adaptable) {
        return adaptable.getPayload().getValue().map(JsonValue::asArray).map(ThingsModelFactory::newFeatureDefinition).orElseThrow(() -> (JsonParseException)JsonParseException.newBuilder().build());
    }

    protected static FeatureProperties featurePropertiesFrom(Adaptable adaptable) {
        return adaptable.getPayload().getValue().map(JsonValue::asObject).map(ThingsModelFactory::newFeatureProperties).orElseThrow(() -> (JsonParseException)JsonParseException.newBuilder().build());
    }

    protected static JsonPointer featurePropertyPointerFrom(Adaptable adaptable) {
        MessagePath path = adaptable.getPayload().getPath();
        return (JsonPointer)path.getSubPointer(3).orElseThrow(() -> (UnknownPathException)UnknownPathException.newBuilder(path).build());
    }

    protected static JsonValue featurePropertyValueFrom(Adaptable adaptable) {
        return adaptable.getPayload().getValue().orElseThrow(() -> (JsonParseException)JsonParseException.newBuilder().build());
    }

    protected static PolicyId policyIdFrom(Adaptable adaptable) {
        return adaptable.getPayload().getValue().map(JsonValue::asString).map(PolicyId::of).orElseThrow(() -> (JsonParseException)JsonParseException.newBuilder().build());
    }

    protected static ThingDefinition thingDefinitionFrom(Adaptable adaptable) {
        return adaptable.getPayload().getValue().map(JsonValue::asString).map(ThingsModelFactory::newDefinition).orElseThrow(() -> (JsonParseException)JsonParseException.newBuilder().build());
    }

    protected static String leafValue(JsonPointer path) {
        return ((JsonKey)path.getLeaf().orElseThrow(() -> (UnknownPathException)UnknownPathException.newBuilder(path).build())).toString();
    }
}

