/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.util.Map;
import java.util.Optional;
import org.eclipse.ditto.base.model.entity.id.NamespacedEntityId;
import org.eclipse.ditto.base.model.entity.type.EntityType;
import org.eclipse.ditto.base.model.json.Jsonifiable;
import org.eclipse.ditto.base.model.signals.WithStreamingSubscriptionId;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonMissingFieldException;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.Payload;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.mappingstrategies.AbstractMappingStrategies;

abstract class AbstractStreamingSubscriptionMappingStrategies<T extends Jsonifiable.WithPredicate<JsonObject, JsonField>>
extends AbstractMappingStrategies<T> {
    protected AbstractStreamingSubscriptionMappingStrategies(Map<String, JsonifiableMapper<T>> mappingStrategies) {
        super(mappingStrategies);
    }

    protected static NamespacedEntityId entityIdFrom(Adaptable adaptable) {
        TopicPath topicPath = adaptable.getTopicPath();
        return NamespacedEntityId.of((EntityType)topicPath.getGroup().getEntityType(), (CharSequence)(topicPath.getNamespace() + ":" + topicPath.getEntityName()));
    }

    protected static EntityType entityTypeFrom(Adaptable adaptable) {
        TopicPath topicPath = adaptable.getTopicPath();
        return topicPath.getGroup().getEntityType();
    }

    protected static JsonPointer resourcePathFrom(Adaptable adaptable) {
        return adaptable.getPayload().getPath();
    }

    protected static String subscriptionIdFrom(Adaptable adaptable) {
        return adaptable.getPayload().getValue().map(value -> (String)value.asObject().getValueOrThrow(WithStreamingSubscriptionId.JsonFields.SUBSCRIPTION_ID)).orElseThrow(() -> (JsonMissingFieldException)JsonMissingFieldException.newBuilder().fieldName((CharSequence)Payload.JsonFields.VALUE.getPointer()).build());
    }

    static <T> Optional<T> getFromValue(Adaptable adaptable, JsonFieldDefinition<T> jsonFieldDefinition) {
        return adaptable.getPayload().getValue().flatMap(value -> value.asObject().getValue(jsonFieldDefinition));
    }
}

