/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.json.Jsonifiable;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.mappingstrategies.AbstractMappingStrategies;
import org.eclipse.ditto.thingsearch.model.signals.events.SubscriptionEvent;

abstract class AbstractSearchMappingStrategies<T extends Jsonifiable.WithPredicate<JsonObject, JsonField>>
extends AbstractMappingStrategies<T> {
    protected AbstractSearchMappingStrategies(Map<String, JsonifiableMapper<T>> mappingStrategies) {
        super(mappingStrategies);
    }

    @Nullable
    protected static JsonFieldSelector selectedFieldsFrom(Adaptable adaptable) {
        return adaptable.getPayload().getFields().orElse(null);
    }

    @Nullable
    protected static String subscriptionIdFrom(Adaptable adaptable) {
        return AbstractSearchMappingStrategies.getFromValue(adaptable, SubscriptionEvent.JsonFields.SUBSCRIPTION_ID).orElse(null);
    }

    static <T> Optional<T> getFromValue(Adaptable adaptable, JsonFieldDefinition<T> jsonFieldDefinition) {
        return adaptable.getPayload().getValue().flatMap(value -> value.asObject().getValue(jsonFieldDefinition));
    }
}

