/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.util.Collection;
import java.util.Map;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.json.Jsonifiable;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.policies.model.Label;
import org.eclipse.ditto.policies.model.PoliciesModelFactory;
import org.eclipse.ditto.policies.model.Policy;
import org.eclipse.ditto.policies.model.PolicyEntry;
import org.eclipse.ditto.policies.model.PolicyId;
import org.eclipse.ditto.policies.model.PolicyImport;
import org.eclipse.ditto.policies.model.PolicyImports;
import org.eclipse.ditto.policies.model.Resource;
import org.eclipse.ditto.policies.model.ResourceKey;
import org.eclipse.ditto.policies.model.Resources;
import org.eclipse.ditto.policies.model.Subject;
import org.eclipse.ditto.policies.model.SubjectId;
import org.eclipse.ditto.policies.model.Subjects;
import org.eclipse.ditto.policies.model.signals.events.SubjectsDeletedPartially;
import org.eclipse.ditto.policies.model.signals.events.SubjectsModifiedPartially;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.MessagePath;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.mappingstrategies.AbstractMappingStrategies;

abstract class AbstractPolicyMappingStrategies<T extends Jsonifiable.WithPredicate<JsonObject, JsonField>>
extends AbstractMappingStrategies<T> {
    private static final int RESOURCES_PATH_LEVEL = 2;
    private static final int SUBJECT_PATH_LEVEL = 3;
    private static final int RESOURCE_PATH_LEVEL = 3;

    protected AbstractPolicyMappingStrategies(Map<String, JsonifiableMapper<T>> mappingStrategies) {
        super(mappingStrategies);
    }

    protected static PolicyId policyIdFromTopicPath(TopicPath topicPath) {
        ConditionChecker.checkNotNull((Object)topicPath, (String)"topicPath");
        return PolicyId.of((String)topicPath.getNamespace(), (String)topicPath.getEntityName());
    }

    protected static PolicyId policyIdFrom(Adaptable adaptable) {
        TopicPath topicPath = adaptable.getTopicPath();
        return PolicyId.of((String)topicPath.getNamespace(), (String)topicPath.getEntityName());
    }

    protected static Policy policyFrom(Adaptable adaptable) {
        JsonObject value = AbstractPolicyMappingStrategies.getValueFromPayload(adaptable);
        return PoliciesModelFactory.newPolicy((JsonObject)value);
    }

    protected static JsonObject policyJsonFrom(Adaptable adaptable) {
        return adaptable.getPayload().getValue().filter(JsonValue::isObject).map(JsonValue::asObject).orElseThrow(() -> new NullPointerException("Payload value must be a non-null object."));
    }

    protected static PolicyEntry policyEntryFrom(Adaptable adaptable) {
        JsonObject value = AbstractPolicyMappingStrategies.getValueFromPayload(adaptable);
        return PoliciesModelFactory.newPolicyEntry((CharSequence)AbstractPolicyMappingStrategies.labelFrom(adaptable), (JsonObject)value);
    }

    protected static Iterable<PolicyEntry> policyEntriesFrom(Adaptable adaptable) {
        JsonObject value = AbstractPolicyMappingStrategies.getValueFromPayload(adaptable);
        return PoliciesModelFactory.newPolicyEntries((JsonObject)value);
    }

    protected static PolicyImports policyImportsFrom(Adaptable adaptable) {
        JsonObject value = AbstractPolicyMappingStrategies.getValueFromPayload(adaptable);
        return PoliciesModelFactory.newPolicyImports((JsonObject)value);
    }

    protected static PolicyImport policyImportFrom(Adaptable adaptable) {
        JsonObject value = AbstractPolicyMappingStrategies.getValueFromPayload(adaptable);
        return PoliciesModelFactory.newPolicyImport((PolicyId)AbstractPolicyMappingStrategies.importedPolicyIdFrom(adaptable), (JsonObject)value);
    }

    static Resource resourceFrom(Adaptable adaptable) {
        return Resource.newInstance((ResourceKey)AbstractPolicyMappingStrategies.entryResourceKeyFromPath(adaptable.getPayload().getPath()), (JsonValue)AbstractPolicyMappingStrategies.getValueFromPayload(adaptable));
    }

    protected static Resources resourcesFrom(Adaptable adaptable) {
        return PoliciesModelFactory.newResources((JsonObject)AbstractPolicyMappingStrategies.getValueFromPayload(adaptable));
    }

    protected static Label labelFrom(Adaptable adaptable) {
        MessagePath path = adaptable.getPayload().getPath();
        return path.getRoot().filter(entries -> Policy.JsonFields.ENTRIES.getPointer().equals((Object)entries.asPointer())).map(entries -> path.nextLevel()).flatMap(JsonPointer::getRoot).map(CharSequence::toString).map(Label::of).orElseThrow(() -> (JsonParseException)JsonParseException.newBuilder().build());
    }

    protected static PolicyId importedPolicyIdFrom(Adaptable adaptable) {
        MessagePath path = adaptable.getPayload().getPath();
        return path.getRoot().filter(entries -> Policy.JsonFields.IMPORTS.getPointer().equals((Object)entries.asPointer())).map(entries -> path.nextLevel()).flatMap(JsonPointer::getRoot).map(CharSequence::toString).map(PolicyId::of).orElseThrow(() -> (JsonParseException)JsonParseException.newBuilder().build());
    }

    protected static ResourceKey entryResourceKeyFromPath(MessagePath path) {
        return path.getRoot().filter(entries -> Policy.JsonFields.ENTRIES.getPointer().equals((Object)entries.asPointer())).flatMap(entries -> path.get(2)).filter(resources -> PolicyEntry.JsonFields.RESOURCES.getPointer().equals((Object)resources.asPointer())).flatMap(resources -> path.getSubPointer(3)).map(PoliciesModelFactory::newResourceKey).orElseThrow(() -> (JsonParseException)JsonParseException.newBuilder().build());
    }

    protected static SubjectId entrySubjectIdFromPath(MessagePath path) {
        return path.getRoot().filter(entries -> Policy.JsonFields.ENTRIES.getPointer().equals((Object)entries.asPointer())).flatMap(entries -> path.get(2)).filter(resources -> PolicyEntry.JsonFields.SUBJECTS.getPointer().equals((Object)resources.asPointer())).flatMap(resources -> path.getSubPointer(3)).map(AbstractPolicyMappingStrategies::stripLeadingSlash).map(PoliciesModelFactory::newSubjectId).orElseThrow(() -> (JsonParseException)JsonParseException.newBuilder().build());
    }

    protected static Subject subjectFrom(Adaptable adaptable) {
        SubjectId subjectIssuerWithId = AbstractPolicyMappingStrategies.entrySubjectIdFromPath(adaptable.getPayload().getPath());
        JsonObject value = AbstractPolicyMappingStrategies.getValueFromPayload(adaptable);
        return PoliciesModelFactory.newSubject((CharSequence)subjectIssuerWithId, (JsonObject)value);
    }

    protected static Subjects subjectsFrom(Adaptable adaptable) {
        JsonObject value = AbstractPolicyMappingStrategies.getValueFromPayload(adaptable);
        return PoliciesModelFactory.newSubjects((JsonObject)value);
    }

    protected static Map<Label, Collection<Subject>> activatedSubjectsFrom(Adaptable adaptable) {
        JsonObject value = AbstractPolicyMappingStrategies.getValueFromPayload(adaptable);
        return SubjectsModifiedPartially.modifiedSubjectsFromJson((JsonObject)((JsonObject)value.getValueOrThrow(SubjectsModifiedPartially.JSON_MODIFIED_SUBJECTS)));
    }

    protected static Map<Label, Collection<SubjectId>> deletedSubjectIdsFrom(Adaptable adaptable) {
        JsonObject value = AbstractPolicyMappingStrategies.getValueFromPayload(adaptable);
        return SubjectsDeletedPartially.deletedSubjectsFromJson((JsonObject)((JsonObject)value.getValueOrThrow(SubjectsDeletedPartially.JSON_DELETED_SUBJECT_IDS)));
    }

    protected static JsonObject getValueFromPayload(Adaptable adaptable) {
        JsonValue value = adaptable.getPayload().getValue().filter(JsonValue::isObject).orElseThrow(() -> new NullPointerException("Payload value must be a non-null object."));
        return value.asObject();
    }

    private static CharSequence stripLeadingSlash(CharSequence charSequence) {
        if (charSequence.length() == 0 || charSequence.charAt(0) != '/') {
            return charSequence;
        }
        return charSequence.subSequence(1, charSequence.length());
    }
}

