/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.nio.ByteBuffer;
import java.util.Map;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.headers.DittoHeadersBuilder;
import org.eclipse.ditto.base.model.json.Jsonifiable;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.messages.model.Message;
import org.eclipse.ditto.messages.model.MessageDirection;
import org.eclipse.ditto.messages.model.MessageHeaderDefinition;
import org.eclipse.ditto.messages.model.MessageHeaders;
import org.eclipse.ditto.messages.model.MessagesModelFactory;
import org.eclipse.ditto.messages.model.signals.commands.MessageDeserializer;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.InvalidPathException;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.MessagePath;
import org.eclipse.ditto.protocol.Payload;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.adapter.UnknownTopicPathException;
import org.eclipse.ditto.protocol.mappingstrategies.AbstractMappingStrategies;

abstract class AbstractMessageMappingStrategies<T extends Jsonifiable.WithPredicate<JsonObject, JsonField>>
extends AbstractMappingStrategies<T> {
    protected AbstractMessageMappingStrategies(Map<String, JsonifiableMapper<T>> mappingStrategies) {
        super(mappingStrategies);
    }

    protected static Message messageFrom(Adaptable adaptable) {
        MessageHeaders messageHeaders = AbstractMessageMappingStrategies.messageHeadersFrom(adaptable);
        Message deserializedMessage = MessageDeserializer.deserializeMessageFromHeadersAndPayload((MessageHeaders)messageHeaders, (JsonValue)adaptable.getPayload().getValue().orElse(null));
        return MessagesModelFactory.newMessageBuilder((MessageHeaders)messageHeaders).payload(deserializedMessage.getPayload().orElse(null)).rawPayload((ByteBuffer)deserializedMessage.getRawPayload().orElse(null)).extra((JsonObject)adaptable.getPayload().getExtra().orElse(null)).build();
    }

    protected static MessageHeaders messageHeadersFrom(Adaptable adaptable) {
        TopicPath topicPath = adaptable.getTopicPath();
        DittoHeadersBuilder dittoHeadersBuilder = adaptable.getDittoHeaders().toBuilder();
        dittoHeadersBuilder.putHeader((CharSequence)MessageHeaderDefinition.THING_ID.getKey(), (CharSequence)(topicPath.getNamespace() + ":" + topicPath.getEntityName()));
        String messageSubject = topicPath.getSubject().orElseThrow(() -> (UnknownTopicPathException)UnknownTopicPathException.newBuilder(topicPath).description("Missing message subject.").build());
        dittoHeadersBuilder.putHeader((CharSequence)MessageHeaderDefinition.SUBJECT.getKey(), (CharSequence)messageSubject);
        Payload payload = adaptable.getPayload();
        MessagePath payloadPath = payload.getPath();
        AbstractMessageMappingStrategies.validatePathForLiveMessages(payloadPath, messageSubject);
        MessageDirection messageDirection = payloadPath.getDirection().orElseThrow(() -> (InvalidPathException)InvalidPathException.newBuilder(payloadPath).build());
        dittoHeadersBuilder.putHeader((CharSequence)MessageHeaderDefinition.DIRECTION.getKey(), (CharSequence)messageDirection.name());
        payloadPath.getFeatureId().ifPresent(featureId -> dittoHeadersBuilder.putHeader((CharSequence)MessageHeaderDefinition.FEATURE_ID.getKey(), (CharSequence)featureId));
        payload.getHttpStatus().ifPresent(httpStatus -> dittoHeadersBuilder.putHeader((CharSequence)MessageHeaderDefinition.STATUS_CODE.getKey(), (CharSequence)String.valueOf(httpStatus.getCode())));
        DittoHeaders newDittoHeaders = dittoHeadersBuilder.build();
        return (MessageHeaders)MessagesModelFactory.newHeadersBuilder((Map)newDittoHeaders).build();
    }

    private static void validatePathForLiveMessages(MessagePath path, String messageSubject) {
        boolean valid;
        String pathAsString = path.toString();
        if (pathAsString.startsWith("/features/")) {
            valid = pathAsString.endsWith("/inbox/messages/" + messageSubject) || pathAsString.endsWith("/outbox/messages/" + messageSubject);
        } else {
            boolean bl = valid = pathAsString.equals("/inbox/messages/" + messageSubject) || pathAsString.equals("/outbox/messages/" + messageSubject);
        }
        if (!valid) {
            String pathPattern = "(/features/[^/]+)?/(inbox|outbox)/messages/" + messageSubject;
            throw (InvalidPathException)InvalidPathException.newBuilder(path).description("It should match the pattern: " + pathPattern).build();
        }
    }

    protected static HttpStatus getHttpStatus(Adaptable adaptable) {
        Payload payload = adaptable.getPayload();
        return payload.getHttpStatus().orElseThrow(() -> new NullPointerException("The message did not contain a HTTP status!"));
    }
}

