/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.util.Map;
import javax.annotation.Nullable;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.common.HttpStatus;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.json.Jsonifiable;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.mappingstrategies.MappingStrategies;
import org.eclipse.ditto.things.model.ThingId;

abstract class AbstractMappingStrategies<T extends Jsonifiable.WithPredicate<JsonObject, JsonField>>
implements MappingStrategies<T> {
    private final Map<String, JsonifiableMapper<T>> mappingStrategies;

    protected AbstractMappingStrategies(Map<String, JsonifiableMapper<T>> mappingStrategies) {
        this.mappingStrategies = (Map)ConditionChecker.checkNotNull(mappingStrategies, (String)"mappingStrategies");
    }

    @Override
    @Nullable
    public JsonifiableMapper<T> find(String type) {
        return this.mappingStrategies.get(type);
    }

    protected static DittoHeaders dittoHeadersFrom(Adaptable adaptable) {
        return adaptable.getDittoHeaders();
    }

    protected static boolean isCreated(Adaptable adaptable) {
        return adaptable.getPayload().getHttpStatus().map(arg_0 -> ((HttpStatus)HttpStatus.CREATED).equals(arg_0)).orElseThrow(() -> (JsonParseException)JsonParseException.newBuilder().build());
    }

    @Nullable
    protected static JsonFieldSelector selectedFieldsFrom(Adaptable adaptable) {
        return adaptable.getPayload().getFields().orElse(null);
    }

    protected static ThingId thingIdFrom(Adaptable adaptable) {
        TopicPath topicPath = adaptable.getTopicPath();
        return ThingId.of((String)topicPath.getNamespace(), (String)topicPath.getEntityName());
    }
}

