/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mappingstrategies;

import java.util.Map;
import org.eclipse.ditto.base.model.common.ConditionChecker;
import org.eclipse.ditto.base.model.json.Jsonifiable;
import org.eclipse.ditto.connectivity.model.ConnectionId;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.protocol.Adaptable;
import org.eclipse.ditto.protocol.JsonifiableMapper;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.mappingstrategies.AbstractMappingStrategies;

abstract class AbstractConnectivityMappingStrategies<T extends Jsonifiable.WithPredicate<JsonObject, JsonField>>
extends AbstractMappingStrategies<T> {
    protected AbstractConnectivityMappingStrategies(Map<String, JsonifiableMapper<T>> mappingStrategies) {
        super(mappingStrategies);
    }

    protected static ConnectionId connectionIdFromTopicPath(TopicPath topicPath) {
        ConditionChecker.checkNotNull((Object)topicPath, (String)"topicPath");
        return ConnectionId.of((CharSequence)topicPath.getEntityName());
    }

    protected static JsonObject getValueFromPayload(Adaptable adaptable) {
        JsonValue value = adaptable.getPayload().getValue().filter(JsonValue::isObject).orElseThrow(() -> new NullPointerException("Payload value must be a non-null object."));
        return value.asObject();
    }
}

