/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mapper;

import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.signals.Signal;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.protocol.PayloadBuilder;
import org.eclipse.ditto.protocol.ProtocolFactory;
import org.eclipse.ditto.protocol.SearchTopicPathBuilder;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.TopicPathBuilder;
import org.eclipse.ditto.protocol.UnknownCommandException;
import org.eclipse.ditto.protocol.mapper.AbstractSignalMapper;
import org.eclipse.ditto.thingsearch.model.signals.commands.ThingSearchCommand;
import org.eclipse.ditto.thingsearch.model.signals.commands.subscription.CancelSubscription;
import org.eclipse.ditto.thingsearch.model.signals.commands.subscription.CreateSubscription;
import org.eclipse.ditto.thingsearch.model.signals.commands.subscription.RequestFromSubscription;

final class ThingSearchSignalMapper<T extends Signal<?>>
extends AbstractSignalMapper<T> {
    ThingSearchSignalMapper() {
    }

    @Override
    TopicPath getTopicPath(T command, TopicPath.Channel channel) {
        TopicPathBuilder topicPathBuilder = this.getTopicPathBuilder();
        SearchTopicPathBuilder searchTopicPathBuilder = ThingSearchSignalMapper.fromTopicPathBuilderWithChannel(topicPathBuilder, channel);
        this.setTopicPathAction(searchTopicPathBuilder, (ThingSearchCommand)command, this.getSupportedActions());
        return searchTopicPathBuilder.build();
    }

    private TopicPathBuilder getTopicPathBuilder() {
        return ProtocolFactory.newTopicPathBuilderFromNamespace("_").things();
    }

    public TopicPath.SearchAction[] getSupportedActions() {
        return new TopicPath.SearchAction[]{TopicPath.SearchAction.REQUEST, TopicPath.SearchAction.CANCEL, TopicPath.SearchAction.SUBSCRIBE};
    }

    private void setTopicPathAction(SearchTopicPathBuilder builder, ThingSearchCommand<?> command, TopicPath.SearchAction ... supportedActions) {
        if (supportedActions.length > 0) {
            String searchCommandName = command.getName();
            TopicPath.SearchAction searchAction = TopicPath.SearchAction.forName(searchCommandName).orElseThrow(() -> this.unknownCommandException(searchCommandName));
            this.setAction(builder, searchAction);
        }
    }

    DittoRuntimeException unknownCommandException(String commandName) {
        return UnknownCommandException.newBuilder(commandName).build();
    }

    private void setAction(SearchTopicPathBuilder builder, TopicPath.SearchAction searchAction) {
        switch (searchAction) {
            case SUBSCRIBE: {
                builder.subscribe();
                break;
            }
            case REQUEST: {
                builder.request();
                break;
            }
            case CANCEL: {
                builder.cancel();
                break;
            }
            default: {
                throw this.unknownCommandException(searchAction.getName());
            }
        }
    }

    private static SearchTopicPathBuilder fromTopicPathBuilderWithChannel(TopicPathBuilder topicPathBuilder, TopicPath.Channel channel) {
        if (channel != TopicPath.Channel.TWIN) {
            throw new IllegalArgumentException("Unknown or unsupported Channel '" + (Object)((Object)channel) + "'");
        }
        SearchTopicPathBuilder searchTopicPathBuilder = topicPathBuilder.twin().search();
        return searchTopicPathBuilder;
    }

    @Override
    void enhancePayloadBuilder(T command, PayloadBuilder payloadBuilder) {
        JsonObjectBuilder payloadContentBuilder = JsonFactory.newObjectBuilder();
        if (command instanceof CreateSubscription) {
            CreateSubscription createCommand = (CreateSubscription)command;
            createCommand.getSelectedFields().ifPresent(payloadBuilder::withFields);
            createCommand.getFilter().ifPresent(filter -> payloadContentBuilder.set(CreateSubscription.JsonFields.FILTER, filter));
            createCommand.getOptions().ifPresent(options -> payloadContentBuilder.set(CreateSubscription.JsonFields.OPTIONS, options));
            createCommand.getNamespaces().ifPresent(namespaces -> {
                JsonArray namespacesArray = (JsonArray)namespaces.stream().map(JsonValue::of).collect(JsonCollectors.valuesToArray());
                payloadContentBuilder.set(CreateSubscription.JsonFields.NAMESPACES, (Object)namespacesArray);
            });
        } else if (command instanceof CancelSubscription) {
            CancelSubscription cancelCommand = (CancelSubscription)command;
            payloadContentBuilder.set(CancelSubscription.JsonFields.SUBSCRIPTION_ID, (Object)cancelCommand.getSubscriptionId());
        } else if (command instanceof RequestFromSubscription) {
            RequestFromSubscription requestCommand = (RequestFromSubscription)command;
            payloadContentBuilder.set(RequestFromSubscription.JsonFields.SUBSCRIPTION_ID, (Object)requestCommand.getSubscriptionId()).set(RequestFromSubscription.JsonFields.DEMAND, (Object)requestCommand.getDemand());
        } else {
            throw (UnknownCommandException)UnknownCommandException.newBuilder(command.getClass().toString()).build();
        }
        payloadBuilder.withValue((JsonValue)payloadContentBuilder.build());
    }
}

