/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mapper;

import org.eclipse.ditto.protocol.PayloadBuilder;
import org.eclipse.ditto.protocol.ProtocolFactory;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.TopicPathBuilder;
import org.eclipse.ditto.protocol.UnknownCommandResponseException;
import org.eclipse.ditto.protocol.mapper.AbstractQuerySignalMapper;
import org.eclipse.ditto.protocol.mapper.ResponseSignalMapper;
import org.eclipse.ditto.things.model.signals.commands.query.ThingQueryCommandResponse;

final class ThingQueryResponseSignalMapper
extends AbstractQuerySignalMapper<ThingQueryCommandResponse<?>>
implements ResponseSignalMapper {
    ThingQueryResponseSignalMapper() {
    }

    @Override
    void validate(ThingQueryCommandResponse<?> commandResponse, TopicPath.Channel channel) {
        String responseName = commandResponse.getClass().getSimpleName().toLowerCase();
        if (!responseName.endsWith("response")) {
            throw (UnknownCommandResponseException)UnknownCommandResponseException.newBuilder(responseName).build();
        }
    }

    @Override
    TopicPathBuilder getTopicPathBuilder(ThingQueryCommandResponse<?> command) {
        return ProtocolFactory.newTopicPathBuilder(command.getEntityId()).things();
    }

    @Override
    void enhancePayloadBuilder(ThingQueryCommandResponse<?> commandResponse, PayloadBuilder payloadBuilder) {
        payloadBuilder.withStatus(commandResponse.getHttpStatus());
        payloadBuilder.withValue(commandResponse.getEntity(commandResponse.getImplementedSchemaVersion()));
    }
}

