/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mapper;

import org.eclipse.ditto.protocol.PayloadBuilder;
import org.eclipse.ditto.protocol.ProtocolFactory;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.TopicPathBuilder;
import org.eclipse.ditto.protocol.UnknownCommandResponseException;
import org.eclipse.ditto.protocol.mapper.AbstractModifySignalMapper;
import org.eclipse.ditto.protocol.mapper.ResponseSignalMapper;
import org.eclipse.ditto.things.model.signals.commands.modify.ThingModifyCommandResponse;

final class ThingModifyResponseSignalMapper
extends AbstractModifySignalMapper<ThingModifyCommandResponse<?>>
implements ResponseSignalMapper {
    ThingModifyResponseSignalMapper() {
    }

    @Override
    void validate(ThingModifyCommandResponse<?> commandResponse, TopicPath.Channel channel) {
        String responseName = commandResponse.getClass().getSimpleName().toLowerCase();
        if (!responseName.endsWith("response")) {
            throw (UnknownCommandResponseException)UnknownCommandResponseException.newBuilder(responseName).build();
        }
    }

    @Override
    TopicPathBuilder getTopicPathBuilder(ThingModifyCommandResponse<?> command) {
        return ProtocolFactory.newTopicPathBuilder(command.getEntityId()).things();
    }

    @Override
    void enhancePayloadBuilder(ThingModifyCommandResponse<?> commandResponse, PayloadBuilder payloadBuilder) {
        payloadBuilder.withStatus(commandResponse.getHttpStatus());
        commandResponse.getEntity(commandResponse.getImplementedSchemaVersion()).ifPresent(payloadBuilder::withValue);
    }
}

