/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mapper;

import java.util.Map;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.protocol.PayloadBuilder;
import org.eclipse.ditto.protocol.ProtocolFactory;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.TopicPathBuilder;
import org.eclipse.ditto.protocol.UnknownChannelException;
import org.eclipse.ditto.protocol.mapper.AbstractSignalMapper;
import org.eclipse.ditto.things.model.signals.events.ThingMerged;

final class ThingMergedEventSignalMapper
extends AbstractSignalMapper<ThingMerged> {
    ThingMergedEventSignalMapper() {
    }

    @Override
    void enhancePayloadBuilder(ThingMerged signal, PayloadBuilder payloadBuilder) {
        payloadBuilder.withRevision(signal.getRevision()).withTimestamp(signal.getTimestamp().orElse(null)).withValue(signal.getValue());
    }

    @Override
    DittoHeaders enhanceHeaders(ThingMerged signal) {
        return ProtocolFactory.newHeadersWithJsonMergePatchContentType((Map<String, String>)signal.getDittoHeaders());
    }

    @Override
    TopicPath getTopicPath(ThingMerged signal, TopicPath.Channel channel) {
        TopicPathBuilder topicPathBuilder = ProtocolFactory.newTopicPathBuilder(signal.getEntityId()).things();
        if (TopicPath.Channel.TWIN == channel) {
            topicPathBuilder = topicPathBuilder.twin();
        } else if (TopicPath.Channel.LIVE == channel) {
            topicPathBuilder = topicPathBuilder.live();
        } else {
            throw (UnknownChannelException)UnknownChannelException.newBuilder(channel, signal.getType()).dittoHeaders(signal.getDittoHeaders()).build();
        }
        return topicPathBuilder.events().merged().build();
    }
}

