/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mapper;

import java.util.Map;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.protocol.PayloadBuilder;
import org.eclipse.ditto.protocol.ProtocolFactory;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.TopicPathBuilder;
import org.eclipse.ditto.protocol.mapper.AbstractModifySignalMapper;
import org.eclipse.ditto.things.model.signals.commands.modify.MergeThing;

final class ThingMergeSignalMapper
extends AbstractModifySignalMapper<MergeThing> {
    private static final TopicPath.Action[] SUPPORTED_ACTIONS = new TopicPath.Action[]{TopicPath.Action.MERGE};

    ThingMergeSignalMapper() {
    }

    @Override
    void enhancePayloadBuilder(MergeThing command, PayloadBuilder payloadBuilder) {
        payloadBuilder.withValue(command.getEntity().orElseGet(() -> ((MergeThing)command).getValue()));
    }

    @Override
    TopicPathBuilder getTopicPathBuilder(MergeThing command) {
        return ProtocolFactory.newTopicPathBuilder(command.getEntityId()).things();
    }

    @Override
    TopicPath.Action[] getSupportedActions() {
        return SUPPORTED_ACTIONS;
    }

    @Override
    DittoHeaders enhanceHeaders(MergeThing signal) {
        return ProtocolFactory.newHeadersWithJsonMergePatchContentType((Map<String, String>)signal.getDittoHeaders());
    }
}

