/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mapper;

import java.util.Map;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.protocol.PayloadBuilder;
import org.eclipse.ditto.protocol.ProtocolFactory;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.TopicPathBuilder;
import org.eclipse.ditto.protocol.UnknownCommandResponseException;
import org.eclipse.ditto.protocol.mapper.AbstractModifySignalMapper;
import org.eclipse.ditto.protocol.mapper.ResponseSignalMapper;
import org.eclipse.ditto.things.model.signals.commands.modify.MergeThingResponse;

final class ThingMergeResponseSignalMapper
extends AbstractModifySignalMapper<MergeThingResponse>
implements ResponseSignalMapper {
    private static final TopicPath.Action[] SUPPORTED_ACTIONS = new TopicPath.Action[]{TopicPath.Action.MERGE};

    ThingMergeResponseSignalMapper() {
    }

    @Override
    void validate(MergeThingResponse commandResponse, TopicPath.Channel channel) {
        String responseName = commandResponse.getClass().getSimpleName().toLowerCase();
        if (!responseName.endsWith("response")) {
            throw (UnknownCommandResponseException)UnknownCommandResponseException.newBuilder(responseName).build();
        }
    }

    @Override
    TopicPathBuilder getTopicPathBuilder(MergeThingResponse command) {
        return ProtocolFactory.newTopicPathBuilder(command.getEntityId()).things();
    }

    @Override
    TopicPath.Action[] getSupportedActions() {
        return SUPPORTED_ACTIONS;
    }

    @Override
    void enhancePayloadBuilder(MergeThingResponse commandResponse, PayloadBuilder payloadBuilder) {
        payloadBuilder.withStatus(commandResponse.getHttpStatus());
    }

    @Override
    DittoHeaders enhanceHeaders(MergeThingResponse signal) {
        return ProtocolFactory.newHeadersWithJsonMergePatchContentType((Map<String, String>)signal.getDittoHeaders());
    }
}

