/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mapper;

import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.protocol.EventsTopicPathBuilder;
import org.eclipse.ditto.protocol.PayloadBuilder;
import org.eclipse.ditto.protocol.ProtocolFactory;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.TopicPathBuilder;
import org.eclipse.ditto.protocol.UnknownChannelException;
import org.eclipse.ditto.protocol.UnknownEventException;
import org.eclipse.ditto.protocol.mapper.AbstractSignalMapper;
import org.eclipse.ditto.things.model.signals.events.ThingEvent;

final class ThingEventSignalMapper
extends AbstractSignalMapper<ThingEvent<?>> {
    ThingEventSignalMapper() {
    }

    @Override
    void enhancePayloadBuilder(ThingEvent<?> signal, PayloadBuilder payloadBuilder) {
        payloadBuilder.withRevision(signal.getRevision()).withTimestamp(signal.getTimestamp().orElse(null));
        Optional value = signal.getEntity(signal.getDittoHeaders().getSchemaVersion().orElse(signal.getLatestSchemaVersion()));
        value.ifPresent(payloadBuilder::withValue);
    }

    @Override
    DittoHeaders enhanceHeaders(ThingEvent<?> signal) {
        Optional value = signal.getEntity(signal.getDittoHeaders().getSchemaVersion().orElse(signal.getLatestSchemaVersion()));
        if (value.isPresent()) {
            return ProtocolFactory.newHeadersWithJsonContentType((Map<String, String>)signal.getDittoHeaders());
        }
        return signal.getDittoHeaders();
    }

    @Override
    TopicPath getTopicPath(ThingEvent<?> signal, TopicPath.Channel channel) {
        EventsTopicPathBuilder topicPathBuilder = ThingEventSignalMapper.getEventsTopicPathBuilderOrThrow(signal, channel);
        String eventName = ThingEventSignalMapper.getLowerCaseEventName(signal);
        if (ThingEventSignalMapper.isAction(eventName, TopicPath.Action.CREATED)) {
            topicPathBuilder.created();
        } else if (ThingEventSignalMapper.isAction(eventName, TopicPath.Action.MODIFIED)) {
            topicPathBuilder.modified();
        } else if (ThingEventSignalMapper.isAction(eventName, TopicPath.Action.DELETED)) {
            topicPathBuilder.deleted();
        } else if (ThingEventSignalMapper.isAction(eventName, TopicPath.Action.MERGED)) {
            topicPathBuilder.merged();
        } else {
            throw (UnknownEventException)UnknownEventException.newBuilder(eventName).build();
        }
        return topicPathBuilder.build();
    }

    private static EventsTopicPathBuilder getEventsTopicPathBuilderOrThrow(ThingEvent<?> event, TopicPath.Channel channel) {
        TopicPathBuilder topicPathBuilder = ProtocolFactory.newTopicPathBuilder(event.getEntityId());
        if (TopicPath.Channel.TWIN == channel) {
            topicPathBuilder = topicPathBuilder.twin();
        } else if (TopicPath.Channel.LIVE == channel) {
            topicPathBuilder = topicPathBuilder.live();
        } else {
            throw (UnknownChannelException)UnknownChannelException.newBuilder(channel, event.getType()).dittoHeaders(event.getDittoHeaders()).build();
        }
        return topicPathBuilder.events();
    }

    private static String getLowerCaseEventName(ThingEvent<?> thingEvent) {
        Class thingEventClass = thingEvent.getClass();
        String eventClassSimpleName = thingEventClass.getSimpleName();
        return eventClassSimpleName.toLowerCase(Locale.ENGLISH);
    }

    private static boolean isAction(String eventName, TopicPath.Action expectedAction) {
        return eventName.contains(expectedAction.getName());
    }
}

