/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mapper;

import java.util.Map;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.protocol.PayloadBuilder;
import org.eclipse.ditto.protocol.ProtocolFactory;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.UnknownEventException;
import org.eclipse.ditto.protocol.mapper.AbstractSignalMapper;
import org.eclipse.ditto.thingsearch.model.signals.events.SubscriptionComplete;
import org.eclipse.ditto.thingsearch.model.signals.events.SubscriptionCreated;
import org.eclipse.ditto.thingsearch.model.signals.events.SubscriptionEvent;
import org.eclipse.ditto.thingsearch.model.signals.events.SubscriptionFailed;
import org.eclipse.ditto.thingsearch.model.signals.events.SubscriptionHasNextPage;

final class SubscriptionEventSignalMapper
extends AbstractSignalMapper<SubscriptionEvent<?>> {
    private static final JsonFieldDefinition<String> SUBSCRIPTION_ID = SubscriptionEvent.JsonFields.SUBSCRIPTION_ID;

    SubscriptionEventSignalMapper() {
    }

    @Override
    void enhancePayloadBuilder(SubscriptionEvent<?> signal, PayloadBuilder payloadBuilder) {
        JsonObjectBuilder payloadContentBuilder = JsonFactory.newObjectBuilder();
        if (signal instanceof SubscriptionCreated) {
            SubscriptionCreated createdEvent = (SubscriptionCreated)signal;
            payloadContentBuilder.set(SUBSCRIPTION_ID, (Object)createdEvent.getSubscriptionId());
        } else if (signal instanceof SubscriptionComplete) {
            SubscriptionComplete completedEvent = (SubscriptionComplete)signal;
            payloadContentBuilder.set(SUBSCRIPTION_ID, (Object)completedEvent.getSubscriptionId());
        } else if (signal instanceof SubscriptionFailed) {
            SubscriptionFailed failedEvent = (SubscriptionFailed)signal;
            payloadContentBuilder.set(SUBSCRIPTION_ID, (Object)failedEvent.getSubscriptionId()).set(SubscriptionFailed.JsonFields.ERROR, (Object)failedEvent.getError().toJson());
        } else if (signal instanceof SubscriptionHasNextPage) {
            SubscriptionHasNextPage hasNextEvent = (SubscriptionHasNextPage)signal;
            payloadContentBuilder.set(SUBSCRIPTION_ID, (Object)hasNextEvent.getSubscriptionId()).set(SubscriptionHasNextPage.JsonFields.ITEMS, (Object)hasNextEvent.getItems());
        } else {
            throw (UnknownEventException)UnknownEventException.newBuilder(signal.getClass().getCanonicalName()).build();
        }
        payloadBuilder.withValue((JsonValue)payloadContentBuilder.build());
    }

    @Override
    DittoHeaders enhanceHeaders(SubscriptionEvent<?> signal) {
        return ProtocolFactory.newHeadersWithJsonContentType((Map<String, String>)signal.getDittoHeaders());
    }

    @Override
    TopicPath getTopicPath(SubscriptionEvent<?> signal, TopicPath.Channel channel) {
        TopicPath topicPath;
        if (signal instanceof SubscriptionCreated) {
            topicPath = TopicPath.fromNamespace("_").things().twin().search().generated().build();
        } else if (signal instanceof SubscriptionComplete) {
            topicPath = TopicPath.fromNamespace("_").things().twin().search().complete().build();
        } else if (signal instanceof SubscriptionFailed) {
            topicPath = TopicPath.fromNamespace("_").things().twin().search().failed().build();
        } else if (signal instanceof SubscriptionHasNextPage) {
            topicPath = TopicPath.fromNamespace("_").things().twin().search().hasNext().build();
        } else {
            throw (UnknownEventException)UnknownEventException.newBuilder(signal.getClass().getCanonicalName()).build();
        }
        return topicPath;
    }
}

