/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mapper;

import java.util.Map;
import org.eclipse.ditto.base.model.headers.DittoHeaders;
import org.eclipse.ditto.base.model.signals.WithStreamingSubscriptionId;
import org.eclipse.ditto.base.model.signals.events.streaming.StreamingSubscriptionComplete;
import org.eclipse.ditto.base.model.signals.events.streaming.StreamingSubscriptionCreated;
import org.eclipse.ditto.base.model.signals.events.streaming.StreamingSubscriptionEvent;
import org.eclipse.ditto.base.model.signals.events.streaming.StreamingSubscriptionFailed;
import org.eclipse.ditto.base.model.signals.events.streaming.StreamingSubscriptionHasNext;
import org.eclipse.ditto.connectivity.model.ConnectionId;
import org.eclipse.ditto.connectivity.model.ConnectivityConstants;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.policies.model.PolicyConstants;
import org.eclipse.ditto.policies.model.PolicyId;
import org.eclipse.ditto.protocol.PayloadBuilder;
import org.eclipse.ditto.protocol.ProtocolFactory;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.TopicPathBuilder;
import org.eclipse.ditto.protocol.UnknownEventException;
import org.eclipse.ditto.protocol.mapper.AbstractSignalMapper;
import org.eclipse.ditto.things.model.ThingConstants;
import org.eclipse.ditto.things.model.ThingId;

final class StreamingSubscriptionEventSignalMapper
extends AbstractSignalMapper<StreamingSubscriptionEvent<?>> {
    private static final JsonFieldDefinition<String> SUBSCRIPTION_ID = WithStreamingSubscriptionId.JsonFields.SUBSCRIPTION_ID;

    StreamingSubscriptionEventSignalMapper() {
    }

    @Override
    void enhancePayloadBuilder(StreamingSubscriptionEvent<?> signal, PayloadBuilder payloadBuilder) {
        JsonObjectBuilder payloadContentBuilder = JsonFactory.newObjectBuilder();
        if (signal instanceof StreamingSubscriptionCreated) {
            StreamingSubscriptionCreated createdEvent = (StreamingSubscriptionCreated)signal;
            payloadContentBuilder.set(SUBSCRIPTION_ID, (Object)createdEvent.getSubscriptionId());
        } else if (signal instanceof StreamingSubscriptionComplete) {
            StreamingSubscriptionComplete completedEvent = (StreamingSubscriptionComplete)signal;
            payloadContentBuilder.set(SUBSCRIPTION_ID, (Object)completedEvent.getSubscriptionId());
        } else if (signal instanceof StreamingSubscriptionFailed) {
            StreamingSubscriptionFailed failedEvent = (StreamingSubscriptionFailed)signal;
            payloadContentBuilder.set(SUBSCRIPTION_ID, (Object)failedEvent.getSubscriptionId()).set(StreamingSubscriptionFailed.JsonFields.ERROR, (Object)failedEvent.getError().toJson());
        } else if (signal instanceof StreamingSubscriptionHasNext) {
            StreamingSubscriptionHasNext hasNext = (StreamingSubscriptionHasNext)signal;
            payloadContentBuilder.set(SUBSCRIPTION_ID, (Object)hasNext.getSubscriptionId()).set(StreamingSubscriptionHasNext.JsonFields.ITEM, (Object)hasNext.getItem());
        } else {
            throw (UnknownEventException)UnknownEventException.newBuilder(signal.getClass().getCanonicalName()).build();
        }
        payloadBuilder.withValue((JsonValue)payloadContentBuilder.build());
    }

    @Override
    DittoHeaders enhanceHeaders(StreamingSubscriptionEvent<?> signal) {
        return ProtocolFactory.newHeadersWithJsonContentType((Map<String, String>)signal.getDittoHeaders());
    }

    @Override
    TopicPath getTopicPath(StreamingSubscriptionEvent<?> signal, TopicPath.Channel channel) {
        TopicPath topicPath;
        TopicPathBuilder topicPathBuilder;
        if (signal.getEntityType().equals((Object)ThingConstants.ENTITY_TYPE)) {
            topicPathBuilder = TopicPath.newBuilder(ThingId.of((CharSequence)signal.getEntityId())).things().twin();
        } else if (signal.getEntityType().equals((Object)PolicyConstants.ENTITY_TYPE)) {
            topicPathBuilder = TopicPath.newBuilder(PolicyId.of((CharSequence)signal.getEntityId())).policies().none();
        } else if (signal.getEntityType().equals((Object)ConnectivityConstants.ENTITY_TYPE)) {
            topicPathBuilder = TopicPath.newBuilder(ConnectionId.of((CharSequence)signal.getEntityId())).connections().none();
        } else {
            throw (UnknownEventException)UnknownEventException.newBuilder(signal.getClass().getCanonicalName()).build();
        }
        if (signal instanceof StreamingSubscriptionCreated) {
            topicPath = topicPathBuilder.streaming().generated().build();
        } else if (signal instanceof StreamingSubscriptionComplete) {
            topicPath = topicPathBuilder.streaming().complete().build();
        } else if (signal instanceof StreamingSubscriptionFailed) {
            topicPath = topicPathBuilder.streaming().failed().build();
        } else if (signal instanceof StreamingSubscriptionHasNext) {
            topicPath = topicPathBuilder.streaming().hasNext().build();
        } else {
            throw (UnknownEventException)UnknownEventException.newBuilder(signal.getClass().getCanonicalName()).build();
        }
        return topicPath;
    }
}

