/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mapper;

import org.eclipse.ditto.base.model.exceptions.DittoRuntimeException;
import org.eclipse.ditto.base.model.signals.WithStreamingSubscriptionId;
import org.eclipse.ditto.base.model.signals.commands.streaming.CancelStreamingSubscription;
import org.eclipse.ditto.base.model.signals.commands.streaming.RequestFromStreamingSubscription;
import org.eclipse.ditto.base.model.signals.commands.streaming.StreamingSubscriptionCommand;
import org.eclipse.ditto.base.model.signals.commands.streaming.SubscribeForPersistedEvents;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.protocol.PayloadBuilder;
import org.eclipse.ditto.protocol.ProtocolFactory;
import org.eclipse.ditto.protocol.StreamingTopicPathBuilder;
import org.eclipse.ditto.protocol.TopicPath;
import org.eclipse.ditto.protocol.TopicPathBuilder;
import org.eclipse.ditto.protocol.UnknownCommandException;
import org.eclipse.ditto.protocol.mapper.AbstractSignalMapper;

final class StreamingSubscriptionCommandSignalMapper<T extends StreamingSubscriptionCommand<?>>
extends AbstractSignalMapper<T> {
    StreamingSubscriptionCommandSignalMapper() {
    }

    @Override
    TopicPath getTopicPath(T command, TopicPath.Channel channel) {
        TopicPathBuilder topicPathBuilder = this.getTopicPathBuilder((StreamingSubscriptionCommand<?>)command);
        StreamingTopicPathBuilder streamingTopicPathBuilder = StreamingSubscriptionCommandSignalMapper.fromTopicPathBuilderWithChannel(topicPathBuilder, channel);
        this.setTopicPathAction(streamingTopicPathBuilder, command, this.getSupportedActions());
        return streamingTopicPathBuilder.build();
    }

    public TopicPath.StreamingAction[] getSupportedActions() {
        return new TopicPath.StreamingAction[]{TopicPath.StreamingAction.REQUEST, TopicPath.StreamingAction.CANCEL, TopicPath.StreamingAction.SUBSCRIBE_FOR_PERSISTED_EVENTS};
    }

    @Override
    void enhancePayloadBuilder(T command, PayloadBuilder payloadBuilder) {
        JsonObjectBuilder payloadContentBuilder = JsonFactory.newObjectBuilder();
        if (command instanceof SubscribeForPersistedEvents) {
            SubscribeForPersistedEvents subscribeCommand = (SubscribeForPersistedEvents)command;
            payloadContentBuilder.set(SubscribeForPersistedEvents.JsonFields.JSON_FROM_HISTORICAL_REVISION, (Object)subscribeCommand.getFromHistoricalRevision()).set(SubscribeForPersistedEvents.JsonFields.JSON_TO_HISTORICAL_REVISION, (Object)subscribeCommand.getToHistoricalRevision());
            subscribeCommand.getFromHistoricalTimestamp().ifPresent(fromTs -> payloadContentBuilder.set(SubscribeForPersistedEvents.JsonFields.JSON_FROM_HISTORICAL_TIMESTAMP, (Object)fromTs.toString()));
            subscribeCommand.getToHistoricalTimestamp().ifPresent(toTs -> payloadContentBuilder.set(SubscribeForPersistedEvents.JsonFields.JSON_TO_HISTORICAL_TIMESTAMP, (Object)toTs.toString()));
            subscribeCommand.getFilter().ifPresent(filter -> payloadContentBuilder.set(SubscribeForPersistedEvents.JsonFields.FILTER, filter));
        } else if (command instanceof CancelStreamingSubscription) {
            CancelStreamingSubscription cancelCommand = (CancelStreamingSubscription)command;
            payloadContentBuilder.set(WithStreamingSubscriptionId.JsonFields.SUBSCRIPTION_ID, (Object)cancelCommand.getSubscriptionId());
        } else if (command instanceof RequestFromStreamingSubscription) {
            RequestFromStreamingSubscription requestCommand = (RequestFromStreamingSubscription)command;
            payloadContentBuilder.set(WithStreamingSubscriptionId.JsonFields.SUBSCRIPTION_ID, (Object)requestCommand.getSubscriptionId()).set(RequestFromStreamingSubscription.JsonFields.DEMAND, (Object)requestCommand.getDemand());
        } else {
            throw (UnknownCommandException)UnknownCommandException.newBuilder(command.getClass().toString()).build();
        }
        payloadBuilder.withValue((JsonValue)payloadContentBuilder.build());
    }

    private static StreamingTopicPathBuilder fromTopicPathBuilderWithChannel(TopicPathBuilder topicPathBuilder, TopicPath.Channel channel) {
        if (channel == TopicPath.Channel.TWIN) {
            return topicPathBuilder.twin().streaming();
        }
        if (channel == TopicPath.Channel.NONE) {
            return topicPathBuilder.none().streaming();
        }
        throw new IllegalArgumentException("Unknown or unsupported Channel '" + (Object)((Object)channel) + "'");
    }

    private TopicPathBuilder getTopicPathBuilder(StreamingSubscriptionCommand<?> command) {
        return ProtocolFactory.newTopicPathBuilder(command.getEntityId());
    }

    private void setTopicPathAction(StreamingTopicPathBuilder builder, T command, TopicPath.StreamingAction ... supportedActions) {
        if (supportedActions.length > 0) {
            String streamingCommandName = command.getName();
            TopicPath.StreamingAction streamingAction = TopicPath.StreamingAction.forName(streamingCommandName).orElseThrow(() -> this.unknownCommandException(streamingCommandName));
            this.setAction(builder, streamingAction);
        }
    }

    DittoRuntimeException unknownCommandException(String commandName) {
        return UnknownCommandException.newBuilder(commandName).build();
    }

    private void setAction(StreamingTopicPathBuilder builder, TopicPath.StreamingAction streamingAction) {
        switch (streamingAction) {
            case SUBSCRIBE_FOR_PERSISTED_EVENTS: {
                builder.subscribe("subscribeForPersistedEvents");
                break;
            }
            case REQUEST: {
                builder.request();
                break;
            }
            case CANCEL: {
                builder.cancel();
                break;
            }
            default: {
                throw this.unknownCommandException(streamingAction.getName());
            }
        }
    }
}

