/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.protocol.mapper;

import java.util.Collection;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.protocol.PayloadBuilder;
import org.eclipse.ditto.protocol.ProtocolFactory;
import org.eclipse.ditto.protocol.TopicPathBuilder;
import org.eclipse.ditto.protocol.mapper.AbstractQuerySignalMapper;
import org.eclipse.ditto.things.model.ThingId;
import org.eclipse.ditto.things.model.signals.commands.query.RetrieveThings;

final class RetrieveThingsSignalMapper
extends AbstractQuerySignalMapper<RetrieveThings> {
    RetrieveThingsSignalMapper() {
    }

    @Override
    TopicPathBuilder getTopicPathBuilder(RetrieveThings command) {
        String namespace = command.getNamespace().orElse("_");
        return ProtocolFactory.newTopicPathBuilderFromNamespace(namespace);
    }

    @Override
    void enhancePayloadBuilder(RetrieveThings command, PayloadBuilder payloadBuilder) {
        command.getSelectedFields().ifPresent(payloadBuilder::withFields);
        payloadBuilder.withValue(RetrieveThingsSignalMapper.createIdsPayload(command.getEntityIds()));
    }

    private static JsonValue createIdsPayload(Collection<ThingId> ids) {
        JsonArray thingIdsArray = (JsonArray)ids.stream().map(String::valueOf).map(JsonFactory::newValue).collect(JsonCollectors.valuesToArray());
        return JsonFactory.newObject().setValue((CharSequence)RetrieveThings.JSON_THING_IDS.getPointer(), (JsonValue)thingIdsArray);
    }
}

